/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.task;

import io.nuls.network.manager.MessageFactory;
import io.nuls.network.manager.MessageManager;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.model.Node;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.message.PingMessage;
import io.nuls.network.netty.container.NodesContainer;
import java.util.List;

public class HeartBeatTask
implements Runnable {
    @Override
    public void run() {
        this.sendCrossPingMessage();
    }

    private void sendCrossPingMessage() {
        NodeGroupManager nodeGroupManager = NodeGroupManager.getInstance();
        List<NodeGroup> nodeGroupList = nodeGroupManager.getNodeGroups();
        for (NodeGroup nodeGroup : nodeGroupList) {
            NodesContainer crossNodesContainer = nodeGroup.getCrossNodeContainer();
            List<Node> nodes = crossNodesContainer.getAvailableNodes();
            PingMessage pingMessage = MessageFactory.getInstance().buildPingMessage(nodeGroup.getMagicNumber());
            for (Node node : nodes) {
                if (node.getType() != 2) continue;
                MessageManager.getInstance().sendToNode(pingMessage, node, true);
            }
        }
    }
}

