/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.task;

import io.netty.buffer.Unpooled;
import io.nuls.core.log.Log;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.manager.TimeManager;
import io.nuls.network.model.Node;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.dto.PeerCacheMessage;
import io.nuls.network.utils.LoggerUtil;
import java.util.ArrayList;
import java.util.List;

public class PeerCacheMsgSendTask
implements Runnable {
    @Override
    public void run() {
        while (true) {
            NodeGroupManager nodeGroupManager = NodeGroupManager.getInstance();
            List<NodeGroup> nodeGroupList = nodeGroupManager.getNodeGroups();
            int count = 0;
            for (NodeGroup nodeGroup : nodeGroupList) {
                int chainId = nodeGroup.getChainId();
                List<Node> nodeList = nodeGroup.getAvailableNodes(false);
                for (Node node : nodeList) {
                    ArrayList<PeerCacheMessage> backList = new ArrayList<PeerCacheMessage>();
                    try {
                        int dealCount = 0;
                        while (node.getCacheSendMsgQueue().size() > 0) {
                            PeerCacheMessage peerCacheMessage = node.getCacheSendMsgQueue().takeFirst();
                            if (TimeManager.currentTimeMillis() - peerCacheMessage.getCreateTime() > 5000L) {
                                LoggerUtil.logger(chainId).error("nodeId={},createTime={},peer cache send fail,drop from cache", new Object[]{node.getId(), peerCacheMessage.getCreateTime()});
                                continue;
                            }
                            ++dealCount;
                            if (node.getChannel().isWritable()) {
                                node.getChannel().writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])peerCacheMessage.getMessage()));
                            } else {
                                backList.add(peerCacheMessage);
                                ++count;
                            }
                            if (dealCount <= 10) continue;
                            break;
                        }
                        node.getCacheSendMsgQueue().addAll(backList);
                    }
                    catch (Exception e) {
                        LoggerUtil.logger(chainId).error(e);
                    }
                }
            }
            try {
                if (count == 0) {
                    Thread.sleep(200L);
                    continue;
                }
                LoggerUtil.COMMON_LOG.debug("cache count={}", new Object[]{count});
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException e) {
                Log.error((Throwable)e);
                Log.error((String)"currentThread interrupt!!");
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }
}

