/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.protocol.service.impl;

import io.nuls.base.basic.ProtocolVersion;
import io.nuls.base.data.BlockExtendsData;
import io.nuls.base.data.BlockHeader;
import io.nuls.common.ConfigBean;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.protocol.manager.ContextManager;
import io.nuls.protocol.model.ProtocolContext;
import io.nuls.protocol.model.po.ProtocolVersionPo;
import io.nuls.protocol.model.po.StatisticsInfo;
import io.nuls.protocol.rpc.call.BlockCall;
import io.nuls.protocol.rpc.call.VersionChangeNotifier;
import io.nuls.protocol.service.ProtocolService;
import io.nuls.protocol.storage.ProtocolVersionStorageService;
import io.nuls.protocol.storage.StatisticsStorageService;
import io.nuls.protocol.utils.PoUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
public class ProtocolServiceImpl
implements ProtocolService {
    @Autowired
    private StatisticsStorageService service;
    @Autowired
    private ProtocolVersionStorageService protocolService;

    @Override
    public boolean startChain(int chainId) {
        return false;
    }

    @Override
    public boolean stopChain(int chainId, boolean cleanData) {
        return false;
    }

    @Override
    public void init(int chainId) {
        ProtocolContext context = ContextManager.getContext(chainId);
        NulsLogger logger = context.getLogger();
        try {
            context.setLatestHeight(BlockCall.getLatestHeight(chainId));
            List<ProtocolVersionPo> list = this.protocolService.getList(chainId);
            list.sort(ProtocolVersionPo.COMPARATOR.reversed());
            ProtocolVersionPo protocolVersionPo = list.get(0);
            ProtocolVersion protocolVersion = PoUtil.getProtocolVersion(protocolVersionPo);
            System.out.println("---------init currentVersion----------," + protocolVersion.getVersion());
            context.setCurrentProtocolVersion(protocolVersion);
            VersionChangeNotifier.notify(chainId, protocolVersion.getVersion());
            VersionChangeNotifier.reRegister(chainId, context, protocolVersion.getVersion());
            ArrayDeque stack = list.stream().map(PoUtil::getProtocolVersion).collect(Collectors.toCollection(ArrayDeque::new));
            context.setProtocolVersionHistory(stack);
            long latestHeight = BlockCall.getLatestHeight(chainId);
            context.setLatestHeight(latestHeight);
            long l = latestHeight % (long)context.getParameters().getInterval();
            context.setLastValidStatisticsInfo(this.service.get(chainId, latestHeight - l));
            context.setCount((int)l);
            context.setCurrentProtocolVersionCount(this.protocolService.getCurrentProtocolVersionCount(chainId));
            List<BlockHeader> blockHeaders = BlockCall.getBlockHeaders(chainId, context.getParameters().getInterval());
            context.setProportionMap(this.initMap(blockHeaders));
            logger.info("cached protocol version-" + protocolVersionPo);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    private Map<ProtocolVersion, Integer> initMap(List<BlockHeader> blockHeaders) {
        if (blockHeaders.isEmpty()) {
            return new HashMap<ProtocolVersion, Integer>();
        }
        blockHeaders.sort(BlockHeader.BLOCK_HEADER_COMPARATOR);
        HashMap<ProtocolVersion, Integer> proportionMap = new HashMap<ProtocolVersion, Integer>();
        for (BlockHeader blockHeader : blockHeaders) {
            BlockExtendsData data = blockHeader.getExtendsData();
            ProtocolVersion newProtocolVersion = new ProtocolVersion();
            newProtocolVersion.setVersion(data.getBlockVersion());
            newProtocolVersion.setEffectiveRatio(data.getEffectiveRatio());
            newProtocolVersion.setContinuousIntervalCount(data.getContinuousIntervalCount());
            proportionMap.merge(newProtocolVersion, 1, Integer::sum);
        }
        return proportionMap;
    }

    private boolean saveGenesisBlock(int chainId, BlockHeader blockHeader) {
        ProtocolContext context = ContextManager.getContext(chainId);
        NulsLogger logger = context.getLogger();
        BlockExtendsData data = blockHeader.getExtendsData();
        context.setLatestHeight(0L);
        Map<ProtocolVersion, Integer> proportionMap = context.getProportionMap();
        ProtocolVersion genesisProtocolVersion = new ProtocolVersion();
        genesisProtocolVersion.setVersion(data.getBlockVersion());
        genesisProtocolVersion.setEffectiveRatio(data.getEffectiveRatio());
        genesisProtocolVersion.setContinuousIntervalCount(data.getContinuousIntervalCount());
        logger.debug("save block, height-0, data-" + data);
        proportionMap.put(genesisProtocolVersion, 1);
        StatisticsInfo statisticsInfo = new StatisticsInfo();
        statisticsInfo.setHeight(0L);
        statisticsInfo.setProtocolVersion(genesisProtocolVersion);
        statisticsInfo.setProtocolVersionMap(proportionMap);
        statisticsInfo.setCount(1L);
        boolean b = this.service.save(chainId, statisticsInfo);
        logger.info("height-0, save-" + b + ", new statisticsInfo-" + statisticsInfo);
        context.setCurrentProtocolVersion(genesisProtocolVersion);
        System.out.println("---------genesisProtocolVersion----------," + genesisProtocolVersion.getVersion());
        context.setCurrentProtocolVersionCount(statisticsInfo.getCount());
        this.protocolService.saveCurrentProtocolVersionCount(chainId, context.getCurrentProtocolVersionCount());
        VersionChangeNotifier.notify(chainId, genesisProtocolVersion.getVersion());
        this.protocolService.save(chainId, PoUtil.getProtocolVersionPo(genesisProtocolVersion, 0L, 0L));
        logger.info("height-0, new protocol version available-" + genesisProtocolVersion);
        context.setCount(0);
        context.setLastValidStatisticsInfo(statisticsInfo);
        proportionMap.clear();
        return true;
    }

    @Override
    public boolean save(int chainId, BlockHeader blockHeader) {
        ProtocolContext context = ContextManager.getContext(chainId);
        NulsLogger logger = context.getLogger();
        StatisticsInfo lastValidStatisticsInfo = context.getLastValidStatisticsInfo();
        BlockExtendsData data = blockHeader.getExtendsData();
        long height = blockHeader.getHeight();
        if (height == 0L) {
            return this.saveGenesisBlock(chainId, blockHeader);
        }
        int count = context.getCount();
        context.setCount(++count);
        context.setLatestHeight(height);
        Map<ProtocolVersion, Integer> proportionMap = context.getProportionMap();
        ProtocolVersion currentProtocolVersion = context.getCurrentProtocolVersion();
        if (!this.validate(data, context)) {
            logger.error("invalid block header-" + height);
            logger.error("currentProtocolVersion-" + currentProtocolVersion);
            logger.error("data-" + data);
            return false;
        }
        ProtocolVersion newProtocolVersion = new ProtocolVersion();
        newProtocolVersion.setVersion(data.getBlockVersion());
        newProtocolVersion.setEffectiveRatio(data.getEffectiveRatio());
        newProtocolVersion.setContinuousIntervalCount(data.getContinuousIntervalCount());
        logger.info("save block, height-" + height + ", data-" + data);
        proportionMap.merge(newProtocolVersion, 1, Integer::sum);
        ConfigBean parameters = context.getParameters();
        short interval = parameters.getInterval();
        if (count == interval) {
            int already = 0;
            Map<Short, ProtocolVersion> localVersionMap = this.getLocalVersionMap(context);
            for (Map.Entry<ProtocolVersion, Integer> entry : proportionMap.entrySet()) {
                ProtocolVersion netProtocolVersion = entry.getKey();
                ProtocolVersion localProtocolVersion = localVersionMap.get(netProtocolVersion.getVersion());
                ProtocolVersion statictisProtocolVersion = localProtocolVersion == null ? netProtocolVersion : localProtocolVersion;
                int real = entry.getValue();
                already += real;
                int expect = interval * statictisProtocolVersion.getEffectiveRatio() / 100;
                if (!statictisProtocolVersion.equals((Object)currentProtocolVersion) && real >= expect) {
                    StatisticsInfo statisticsInfo = new StatisticsInfo();
                    statisticsInfo.setHeight(height);
                    statisticsInfo.setProtocolVersion(statictisProtocolVersion);
                    statisticsInfo.setProtocolVersionMap(proportionMap);
                    if (lastValidStatisticsInfo.getProtocolVersion().equals((Object)statictisProtocolVersion)) {
                        statisticsInfo.setCount(lastValidStatisticsInfo.getCount() + 1L);
                    } else {
                        statisticsInfo.setCount(1L);
                    }
                    boolean b = this.service.save(chainId, statisticsInfo);
                    logger.info("height-" + height + ", save-" + b + ", new statisticsInfo-" + statisticsInfo);
                    if (statisticsInfo.getCount() >= (long)statictisProtocolVersion.getContinuousIntervalCount() && statictisProtocolVersion.getVersion() > currentProtocolVersion.getVersion()) {
                        short localVersion = context.getLocalProtocolVersion().getVersion();
                        if (statictisProtocolVersion.getVersion() > localVersion) {
                            logger.error("localVersion-" + localVersion);
                            logger.error("newVersion-" + statictisProtocolVersion.getVersion());
                            logger.error("Older versions of the wallet automatically stop working, Please upgrade the latest version of the wallet!");
                            System.exit(1);
                        }
                        context.setCurrentProtocolVersion(statictisProtocolVersion);
                        context.setCurrentProtocolVersionCount(statisticsInfo.getCount());
                        this.protocolService.saveCurrentProtocolVersionCount(chainId, context.getCurrentProtocolVersionCount());
                        context.getProtocolVersionHistory().push(statictisProtocolVersion);
                        VersionChangeNotifier.notify(chainId, statictisProtocolVersion.getVersion());
                        VersionChangeNotifier.reRegister(chainId, context, statictisProtocolVersion.getVersion());
                        ProtocolVersionPo oldProtocolVersionPo = this.protocolService.get(chainId, currentProtocolVersion.getVersion());
                        oldProtocolVersionPo.setEndHeight(height);
                        this.protocolService.save(chainId, oldProtocolVersionPo);
                        this.protocolService.save(chainId, PoUtil.getProtocolVersionPo(statictisProtocolVersion, height + 1L, 0L));
                        logger.info("height-" + height + ", new protocol version available-" + statictisProtocolVersion);
                    }
                    context.setCount(0);
                    context.setLastValidStatisticsInfo(statisticsInfo);
                    proportionMap.clear();
                    return true;
                }
                if (already <= interval - interval * parameters.getEffectiveRatioMinimum() / 100) continue;
                break;
            }
            StatisticsInfo statisticsInfo = new StatisticsInfo();
            statisticsInfo.setHeight(height);
            statisticsInfo.setProtocolVersion(currentProtocolVersion);
            statisticsInfo.setProtocolVersionMap(proportionMap);
            statisticsInfo.setCount(context.getCurrentProtocolVersionCount() + 1L);
            context.setCurrentProtocolVersionCount(context.getCurrentProtocolVersionCount() + 1L);
            this.protocolService.saveCurrentProtocolVersionCount(chainId, context.getCurrentProtocolVersionCount());
            boolean b = this.service.save(chainId, statisticsInfo);
            logger.info("height-" + height + ", save-" + b + ", new statisticsInfo-" + statisticsInfo);
            context.setCount(0);
            context.setLastValidStatisticsInfo(statisticsInfo);
            proportionMap.clear();
        }
        return true;
    }

    private Map<Short, ProtocolVersion> getLocalVersionMap(ProtocolContext context) {
        HashMap<Short, ProtocolVersion> map = new HashMap<Short, ProtocolVersion>();
        context.getLocalVersionList().forEach(e -> map.put(e.getVersion(), (ProtocolVersion)e));
        return map;
    }

    @Override
    public boolean rollback(int chainId, BlockHeader blockHeader) {
        ProtocolContext context = ContextManager.getContext(chainId);
        NulsLogger logger = context.getLogger();
        BlockExtendsData data = blockHeader.getExtendsData();
        long height = blockHeader.getHeight();
        int count = context.getCount();
        --count;
        Map<ProtocolVersion, Integer> proportionMap = context.getProportionMap();
        ProtocolVersion newProtocolVersion = new ProtocolVersion();
        if (!this.validate(data, context)) {
            logger.error("invalid block header-" + height);
            logger.error("currentProtocolVersion-" + context.getCurrentProtocolVersion());
            logger.error("data-" + data);
            return false;
        }
        newProtocolVersion.setVersion(data.getBlockVersion());
        newProtocolVersion.setEffectiveRatio(data.getEffectiveRatio());
        newProtocolVersion.setContinuousIntervalCount(data.getContinuousIntervalCount());
        logger.info("rollback block, height-" + height + ", protocol-" + newProtocolVersion);
        proportionMap.merge(newProtocolVersion, 1, (a, b) -> a - b);
        ConfigBean parameters = context.getParameters();
        short interval = parameters.getInterval();
        if (count < 0) {
            Deque<ProtocolVersion> history;
            StatisticsInfo oldValidStatisticsInfo = this.service.get(chainId, height);
            boolean b2 = this.service.delete(chainId, height);
            logger.info("height-" + height + ", delete-" + b2);
            count = interval - 1;
            StatisticsInfo newValidStatisticsInfo = this.service.get(chainId, height - (long)interval);
            context.setLastValidStatisticsInfo(newValidStatisticsInfo);
            context.setProportionMap(oldValidStatisticsInfo.getProtocolVersionMap());
            context.getProportionMap().merge(newProtocolVersion, 1, (x, y) -> x - y);
            context.setCurrentProtocolVersionCount(context.getCurrentProtocolVersionCount() - 1L);
            this.protocolService.saveCurrentProtocolVersionCount(chainId, context.getCurrentProtocolVersionCount());
            ProtocolVersion currentProtocolVersion = context.getCurrentProtocolVersion();
            if (newValidStatisticsInfo.getProtocolVersion().equals((Object)currentProtocolVersion) && newValidStatisticsInfo.getCount() < (long)currentProtocolVersion.getContinuousIntervalCount() && (history = context.getProtocolVersionHistory()).size() > 1) {
                ProtocolVersion pop = history.pop();
                ProtocolVersion protocolVersion = history.peek();
                context.setCurrentProtocolVersion(protocolVersion);
                VersionChangeNotifier.notify(chainId, protocolVersion.getVersion());
                VersionChangeNotifier.reRegister(chainId, context, protocolVersion.getVersion());
                this.protocolService.delete(chainId, pop.getVersion());
                ProtocolVersionPo protocolVersionPo = this.protocolService.get(chainId, protocolVersion.getVersion());
                protocolVersionPo.setEndHeight(0L);
                this.protocolService.save(chainId, protocolVersionPo);
                logger.info("height-" + height + ", protocol version rollback-" + pop + ", new protocol version available-" + protocolVersion);
            }
        }
        context.setCount(count);
        context.setLatestHeight(height - 1L);
        return true;
    }

    private boolean validate(BlockExtendsData data, ProtocolContext context) {
        short blockVersion = data.getBlockVersion();
        ProtocolVersion currentProtocolVersion = context.getCurrentProtocolVersion();
        if (currentProtocolVersion.getVersion() > blockVersion) {
            return false;
        }
        ConfigBean parameters = context.getParameters();
        byte effectiveRatio = data.getEffectiveRatio();
        if (effectiveRatio < parameters.getEffectiveRatioMinimum()) {
            return false;
        }
        short continuousIntervalCount = data.getContinuousIntervalCount();
        return continuousIntervalCount >= parameters.getContinuousIntervalCountMinimum();
    }
}

