/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.protocol.storage.impl;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.protocol.manager.ContextManager;
import io.nuls.protocol.model.po.ProtocolVersionPo;
import io.nuls.protocol.storage.ProtocolVersionStorageService;
import java.util.ArrayList;
import java.util.List;

@Component
public class ProtocolVersionStorageServiceImpl
implements ProtocolVersionStorageService {
    @Override
    public boolean save(int chainId, ProtocolVersionPo po) {
        try {
            byte[] bytes = po.serialize();
            return RocksDBService.put((String)("protocol_version_po_" + chainId), (byte[])ByteUtils.shortToBytes((short)po.getVersion()), (byte[])bytes);
        }
        catch (Exception e) {
            ContextManager.getContext(chainId).getLogger().error(e);
            return false;
        }
    }

    @Override
    public ProtocolVersionPo get(int chainId, short version) {
        try {
            ProtocolVersionPo po = new ProtocolVersionPo();
            byte[] bytes = RocksDBService.get((String)("protocol_version_po_" + chainId), (byte[])ByteUtils.shortToBytes((short)version));
            po.parse(new NulsByteBuffer(bytes));
            return po;
        }
        catch (Exception e) {
            ContextManager.getContext(chainId).getLogger().error(e);
            return null;
        }
    }

    @Override
    public boolean delete(int chainId, short version) {
        try {
            return RocksDBService.delete((String)("protocol_version_po_" + chainId), (byte[])ByteUtils.shortToBytes((short)version));
        }
        catch (Exception e) {
            ContextManager.getContext(chainId).getLogger().error(e);
            return false;
        }
    }

    @Override
    public List<ProtocolVersionPo> getList(int chainId) {
        try {
            ArrayList<ProtocolVersionPo> pos = new ArrayList<ProtocolVersionPo>();
            List valueList = RocksDBService.valueList((String)("protocol_version_po_" + chainId));
            for (byte[] bytes : valueList) {
                ProtocolVersionPo po = new ProtocolVersionPo();
                po.parse(new NulsByteBuffer(bytes));
                pos.add(po);
            }
            return pos;
        }
        catch (Exception e) {
            ContextManager.getContext(chainId).getLogger().error(e);
            return List.of();
        }
    }

    @Override
    public boolean saveCurrentProtocolVersionCount(int chainId, long currentProtocolVersionCount) {
        try {
            boolean b = RocksDBService.put((String)("cached_info_" + chainId), (byte[])"currentProtocolVersionCount".getBytes(), (byte[])ByteUtils.longToBytes((long)currentProtocolVersionCount));
            ContextManager.getContext(chainId).getLogger().debug("saveCurrentProtocolVersionCount, currentProtocolVersionCount-" + currentProtocolVersionCount + ",b-" + b);
            return b;
        }
        catch (Exception e) {
            ContextManager.getContext(chainId).getLogger().error(e);
            return false;
        }
    }

    @Override
    public long getCurrentProtocolVersionCount(int chainId) {
        try {
            byte[] bytes = RocksDBService.get((String)("cached_info_" + chainId), (byte[])"currentProtocolVersionCount".getBytes());
            long value = 0L;
            value = bytes.length == 4 ? (long)ByteUtils.bytesToInt((byte[])bytes) : ByteUtils.byteToLong((byte[])bytes);
            if (value < 0L) {
                value = 65536L + value;
            }
            return value;
        }
        catch (Exception e) {
            ContextManager.getContext(chainId).getLogger().error(e);
            return 0L;
        }
    }
}

