/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.message.handler;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.NulsHash;
import io.nuls.base.protocol.MessageProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.transaction.manager.ChainManager;
import io.nuls.transaction.message.ForwardTxMessage;
import io.nuls.transaction.message.GetTxMessage;
import io.nuls.transaction.model.bo.Chain;
import io.nuls.transaction.rpc.call.NetworkCall;
import io.nuls.transaction.service.TxService;
import io.nuls.transaction.utils.LoggerUtil;
import io.nuls.transaction.utils.TxDuplicateRemoval;

@Component(value="ForwardTxMessageHandlerV1")
public class ForwardTxMessageHandler
implements MessageProcessor {
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private TxService txService;

    public String getCmd() {
        return "newHash";
    }

    public void process(int chainId, String nodeId, String msgStr) {
        Chain chain = null;
        try {
            chain = this.chainManager.getChain(chainId);
            if (!chain.getProcessTxStatus().get()) {
                return;
            }
            ForwardTxMessage message = (ForwardTxMessage)((Object)RPCUtil.getInstanceRpcStr((String)msgStr, ForwardTxMessage.class));
            if (message == null) {
                return;
            }
            NulsHash hash = message.getTxHash();
            String hashHex = hash.toHex();
            if (TxDuplicateRemoval.exist(hashHex)) {
                TxDuplicateRemoval.putExcludeNode(hashHex, nodeId);
                return;
            }
            GetTxMessage getTxMessage = new GetTxMessage();
            getTxMessage.setTxHash(hash);
            NetworkCall.sendToNode(chain, getTxMessage, nodeId, "askTx");
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
        }
    }

    private void errorLogProcess(Chain chain, Exception e) {
        if (chain == null) {
            LoggerUtil.LOG.error(e);
        } else {
            chain.getLogger().error(e);
        }
    }
}

