/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.rpc.call;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.MultiSigAccount;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.transaction.constant.TxErrorCode;
import io.nuls.transaction.model.dto.AccountBlockDTO;
import io.nuls.transaction.model.po.AccountBlockExtendPO;
import io.nuls.transaction.model.po.AccountBlockPO;
import io.nuls.transaction.rpc.call.TransactionCall;
import io.nuls.transaction.utils.TxUtil;
import java.util.HashMap;
import java.util.Map;

public class AccountCall {
    public static MultiSigAccount getMultiSigAccount(byte[] multiSignAddress) throws NulsException {
        try {
            String address = AddressTool.getStringAddressByBytes((byte[])multiSignAddress);
            int chainId = AddressTool.getChainIdByAddress((String)address);
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            params.put("address", address);
            HashMap result = (HashMap)TransactionCall.requestAndResponse(ModuleE.AC.abbr, "ac_getMultiSignAccount", params);
            String mAccountStr = (String)result.get("value");
            return null == mAccountStr ? null : (MultiSigAccount)TxUtil.getInstanceRpcStr(mAccountStr, MultiSigAccount.class);
        }
        catch (RuntimeException e) {
            Log.error((Throwable)e);
            throw new NulsException(TxErrorCode.RPC_REQUEST_FAILD);
        }
    }

    public static boolean isBlockAccount(int chainId, String address) {
        try {
            if (StringUtils.isBlank((String)address)) {
                return false;
            }
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("chainId", chainId);
            params.put("address", address);
            Map resultMap = (Map)TransactionCall.requestAndResponse(ModuleE.AC.abbr, "ac_isBlockAccount", params);
            boolean isBlock = (Boolean)resultMap.get("value");
            return isBlock;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    public static AccountBlockDTO getBlockAccount(int chainId, String address) {
        try {
            if (StringUtils.isBlank((String)address)) {
                return null;
            }
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("chainId", chainId);
            params.put("address", address);
            Map resultMap = (Map)TransactionCall.requestAndResponse(ModuleE.AC.abbr, "ac_getBlockAccountBytes", params);
            String hex = (String)resultMap.get("value");
            if (StringUtils.isBlank((String)hex)) {
                return null;
            }
            AccountBlockPO po = new AccountBlockPO();
            po.parse(HexUtil.decode((String)hex), 0);
            AccountBlockDTO dto = new AccountBlockDTO();
            dto.setAddress(po.getAddress());
            if (po.getExtend() != null) {
                AccountBlockExtendPO extendPO = new AccountBlockExtendPO();
                extendPO.parse(po.getExtend(), 0);
                dto.setTypes(extendPO.getTypes());
                dto.setContracts(extendPO.getContracts());
                dto.setExtend(extendPO.getExtend());
            }
            return dto;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return null;
        }
    }
}

