/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.rpc.call;

import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import io.nuls.transaction.constant.TxErrorCode;
import io.nuls.transaction.model.bo.Chain;
import io.nuls.transaction.rpc.call.TransactionCall;
import java.util.HashMap;
import java.util.Map;

public class ContractCall {
    public static boolean contractBatchBegin(Chain chain, long blockHeight, long blockTime, String packingAddress, String preStateRoot, int blockType) {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("chainId", chain.getChainId());
        params.put("blockHeight", blockHeight);
        params.put("blockTime", blockTime);
        params.put("packingAddress", packingAddress);
        params.put("preStateRoot", preStateRoot);
        params.put("blockType", blockType);
        try {
            TransactionCall.requestAndResponse(ModuleE.SC.abbr, "sc_batch_begin", params);
            return true;
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return false;
        }
    }

    public static boolean invokeContract(Chain chain, String tx, int blockType) throws NulsException {
        return ContractCall.invokeContract(chain, tx, blockType, null);
    }

    public static boolean invokeContract(Chain chain, String tx, int blockType, Long timeOut) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("chainId", chain.getChainId());
            params.put("tx", tx);
            params.put("blockType", blockType);
            HashMap result = (HashMap)TransactionCall.requestAndResponse(ModuleE.SC.abbr, "sc_invoke_contract", params, timeOut);
            Boolean value = (Boolean)result.get("value");
            if (null == value) {
                chain.getLogger().error("call sc_invoke_contract response value is null, error:{}", new Object[]{TxErrorCode.REMOTE_RESPONSE_DATA_NOT_FOUND.getCode()});
                throw new NulsException(TxErrorCode.REMOTE_RESPONSE_DATA_NOT_FOUND);
            }
            return value;
        }
        catch (RuntimeException e) {
            chain.getLogger().error((Exception)e);
            throw new NulsException(TxErrorCode.RPC_REQUEST_FAILD);
        }
    }

    public static Map<String, Object> invokeContractV8(Chain chain, String tx, int blockType) throws NulsException {
        return ContractCall.invokeContractV8(chain, tx, blockType, null);
    }

    public static Map<String, Object> invokeContractV8(Chain chain, String tx, int blockType, Long timeOut) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("chainId", chain.getChainId());
            params.put("tx", tx);
            params.put("blockType", blockType);
            HashMap result = (HashMap)TransactionCall.requestAndResponse(ModuleE.SC.abbr, "sc_invoke_contract", params, timeOut);
            if (null == result) {
                chain.getLogger().error("call sc_invoke_contract response result is null, error:{}", new Object[]{TxErrorCode.REMOTE_RESPONSE_DATA_NOT_FOUND.getCode()});
                throw new NulsException(TxErrorCode.REMOTE_RESPONSE_DATA_NOT_FOUND);
            }
            return result;
        }
        catch (RuntimeException e) {
            chain.getLogger().error((Exception)e);
            throw new NulsException(TxErrorCode.RPC_REQUEST_FAILD);
        }
    }

    public static boolean contractBatchBeforeEnd(Chain chain, long blockHeight, int blockType) {
        HashMap<String, Number> params = new HashMap<String, Number>(8);
        params.put("chainId", chain.getChainId());
        params.put("blockHeight", blockHeight);
        params.put("blockType", blockType);
        try {
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.SC.abbr, (String)"sc_batch_before_end", params);
            return response.isSuccess();
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return false;
        }
    }

    public static Map<String, Object> contractBatchEnd(Chain chain, long blockHeight) throws NulsException {
        return ContractCall.contractBatchEnd(chain, blockHeight, null);
    }

    public static Map<String, Object> contractBatchEnd(Chain chain, long blockHeight, Long timeOut) throws NulsException {
        HashMap<String, Number> params = new HashMap<String, Number>(4);
        params.put("chainId", chain.getChainId());
        params.put("blockHeight", blockHeight);
        try {
            Map result = (Map)TransactionCall.requestAndResponse(ModuleE.SC.abbr, "sc_batch_end", params, timeOut);
            return result;
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            throw new NulsException(TxErrorCode.RPC_REQUEST_FAILD);
        }
    }

    public static Map<String, Object> contractPackageBatchEnd(Chain chain, long blockHeight) throws NulsException {
        HashMap<String, Number> params = new HashMap<String, Number>(4);
        params.put("chainId", chain.getChainId());
        params.put("blockHeight", blockHeight);
        try {
            Map result = (Map)TransactionCall.requestAndResponse(ModuleE.SC.abbr, "sc_package_batch_end", params);
            return result;
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            throw new NulsException(TxErrorCode.RPC_REQUEST_FAILD);
        }
    }
}

