/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.rpc.cmd;

import com.fasterxml.jackson.databind.DeserializationFeature;
import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.base.protocol.TxRegisterDetail;
import io.nuls.base.signture.MultiSignTxSignature;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.ObjectUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.CmdPriority;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.transaction.cache.PackablePool;
import io.nuls.transaction.constant.TxContext;
import io.nuls.transaction.constant.TxErrorCode;
import io.nuls.transaction.manager.ChainManager;
import io.nuls.transaction.manager.TxManager;
import io.nuls.transaction.model.bo.Chain;
import io.nuls.transaction.model.bo.TxPackage;
import io.nuls.transaction.model.dto.ModuleTxRegisterDTO;
import io.nuls.transaction.model.po.TransactionConfirmedPO;
import io.nuls.transaction.rpc.call.NetworkCall;
import io.nuls.transaction.service.ConfirmedTxService;
import io.nuls.transaction.service.TxService;
import io.nuls.transaction.utils.LoggerUtil;
import io.nuls.transaction.utils.TxUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.TX)
public class TransactionCmd
extends BaseCmd {
    @Autowired
    private TxService txService;
    @Autowired
    private ConfirmedTxService confirmedTxService;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private PackablePool packablePool;

    @CmdAnnotation(cmd="tx_register", version=1.0, description="Registration module transaction/Register module transactions")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="moduleCode", parameterType="String", parameterDes="Module for registering transactionscode"), @Parameter(parameterName="list", requestType=@TypeDescriptor(value=List.class, collectionElement=TxRegisterDetail.class), parameterDes="Data to be registered for transactions"), @Parameter(parameterName="delList", requestType=@TypeDescriptor(value=List.class, collectionElement=Integer.class), parameterDes="Pending removal of registered transaction data", canNull=true)})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Is registration successful")}))
    public Response register(Map params) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(2);
        boolean result = false;
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("moduleCode"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            JSONUtils.getInstance().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            ModuleTxRegisterDTO moduleTxRegisterDto = (ModuleTxRegisterDTO)JSONUtils.map2pojo((Map)params, ModuleTxRegisterDTO.class);
            chain = this.chainManager.getChain(moduleTxRegisterDto.getChainId());
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            List<TxRegisterDetail> txRegisterList = moduleTxRegisterDto.getList();
            if (moduleTxRegisterDto == null || txRegisterList == null) {
                throw new NulsException(TxErrorCode.TX_NOT_EXIST);
            }
            result = this.txService.register(chain, moduleTxRegisterDto);
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        map.put("value", result);
        return this.success(map);
    }

    @CmdAnnotation(cmd="tx_broadcast", version=1.0, description="Directly broadcast new transactions/broadcast a new transaction")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="tx", parameterType="String", parameterDes="Transaction serialization data string")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Whether successful"), @Key(name="hash", description="transactionhash")}))
    public Response broadcastTx(Map params) {
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("tx"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            String txStr = (String)params.get("tx");
            Transaction transaction = (Transaction)TxUtil.getInstanceRpcStr(txStr, Transaction.class);
            CoinData cd = transaction.getCoinDataInstance();
            for (CoinFrom from : cd.getFrom()) {
                if (chain.getChainId() != 1 || AddressTool.getChainIdByAddress((byte[])from.getAddress()) != 2) continue;
                throw new NulsException(TxErrorCode.INVALID_ADDRESS, "address is testnet address Exception");
            }
            for (CoinTo to : cd.getTo()) {
                if (chain.getChainId() != 1 || AddressTool.getChainIdByAddress((byte[])to.getAddress()) != 2) continue;
                throw new NulsException(TxErrorCode.INVALID_ADDRESS, "address is testnet address Exception");
            }
            boolean rs = NetworkCall.broadcastTx(chain, transaction);
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("value", rs);
            map.put("hash", transaction.getHash().toHex());
            return this.success(map);
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="tx_newTx", version=1.0, description="Receive local new transactions/receive a new transaction")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="tx", parameterType="String", parameterDes="Transaction serialization data string")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Whether successful"), @Key(name="hash", description="transactionhash")}))
    public Response newTx(Map params) {
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("tx"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            String txStr = (String)params.get("tx");
            Transaction transaction = (Transaction)TxUtil.getInstanceRpcStr(txStr, Transaction.class);
            this.txService.newTx(chain, transaction);
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("value", true);
            map.put("hash", transaction.getHash().toHex());
            return this.success(map);
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="tx_packableTxs", version=1.0, description="Obtain a packable transaction set/returns a list of packaged transactions")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="endTimestamp", requestType=@TypeDescriptor(value=long.class), parameterDes="Deadline"), @Parameter(parameterName="maxTxDataSize", requestType=@TypeDescriptor(value=int.class), parameterDes="Maximum capacity of transaction set"), @Parameter(parameterName="blockTime", requestType=@TypeDescriptor(value=long.class), parameterDes="Time of block production this time"), @Parameter(parameterName="packingAddress", parameterType="String", parameterDes="Current block address"), @Parameter(parameterName="preStateRoot", parameterType="String", parameterDes="The state root of the previous block")})
    @ResponseData(name="Return value", description="Return aMap, including threekey", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="list", valueType=List.class, valueElement=String.class, description="Packable transaction set"), @Key(name="stateRoot", description="The current state root of the block"), @Key(name="packageHeight", valueType=long.class, description="The height of the packaged blocks this time")}))
    public Response packableTxs(Map params) {
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("endTimestamp"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("maxTxDataSize"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("blockTime"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("packingAddress"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("preStateRoot"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            long endTimestamp = Long.parseLong(params.get("endTimestamp").toString());
            int maxTxDataSize = (Integer)params.get("maxTxDataSize");
            long blockTime = Long.parseLong(params.get("blockTime").toString());
            String packingAddress = (String)params.get("packingAddress");
            String preStateRoot = (String)params.get("preStateRoot");
            TxPackage txPackage = ProtocolGroupManager.getCurrentVersion((int)chain.getChainId()) >= TxContext.UPDATE_VERSION_CONTRACT_ASSET ? this.txService.getPackableTxsV8(chain, endTimestamp, maxTxDataSize, blockTime, packingAddress, preStateRoot) : this.txService.getPackableTxs(chain, endTimestamp, maxTxDataSize, blockTime, packingAddress, preStateRoot);
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("list", txPackage.getList());
            map.put("stateRoot", txPackage.getStateRoot());
            map.put("packageHeight", txPackage.getPackageHeight());
            return this.success(map);
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="tx_backPackableTxs", version=1.0, description="The consensus module returns transactions that cannot be packaged and adds them back to the list to be packaged/back packaged transactions")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="txList", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="Transaction serialization data string collection")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Whether successful")}))
    public Response backPackableTxs(Map params) {
        Chain chain = null;
        try {
            int count;
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("txList"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            List txStrList = (List)params.get("txList");
            for (int i = count = txStrList.size() - 1; i >= 0; --i) {
                Transaction tx = (Transaction)TxUtil.getInstanceRpcStr((String)txStrList.get(i), Transaction.class);
                this.packablePool.offerFirstOnlyHash(chain, tx);
            }
            HashMap<String, Boolean> map = new HashMap<String, Boolean>(2);
            map.put("value", true);
            return this.success(map);
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="tx_save", priority=CmdPriority.HIGH, version=1.0, description="Save transactions for new blocks/Save the confirmed transaction")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="txList", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="Transaction set to be saved"), @Parameter(parameterName="contractList", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="Smart contract trading"), @Parameter(parameterName="blockHeader", parameterType="String", parameterDes="Block head")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Whether successful")}))
    public Response txSave(Map params) {
        HashMap map = new HashMap(16);
        boolean result = false;
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("txList"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("blockHeader"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            List txStrList = (List)params.get("txList");
            if (null == txStrList) {
                throw new NulsException(TxErrorCode.PARAMETER_ERROR);
            }
            List contractList = (List)params.get("contractList");
            result = this.confirmedTxService.saveTxList(chain, txStrList, contractList, (String)params.get("blockHeader"));
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(2);
        resultMap.put("value", result);
        return this.success(resultMap);
    }

    @CmdAnnotation(cmd="tx_gengsisSave", version=1.0, description="Save transactions for Genesis blocks/Save the transactions of the Genesis block ")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="txList", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="Transaction set to be saved"), @Parameter(parameterName="blockHeader", parameterType="String", parameterDes="Block head")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Whether successful")}))
    public Response txGengsisSave(Map params) {
        HashMap map = new HashMap(16);
        boolean result = false;
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("txList"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("blockHeader"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            List txStrList = (List)params.get("txList");
            result = this.confirmedTxService.saveGengsisTxList(chain, txStrList, (String)params.get("blockHeader"));
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(2);
        resultMap.put("value", result);
        return this.success(resultMap);
    }

    @CmdAnnotation(cmd="tx_rollback", priority=CmdPriority.HIGH, version=1.0, description="Rollback block transactions/transaction rollback")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="txHashList", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="Collection of transactions to be rolled back"), @Parameter(parameterName="blockHeader", parameterType="String", parameterDes="Block head")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Whether successful")}))
    public Response txRollback(Map params) {
        boolean result;
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("txHashList"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("blockHeader"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            List txHashStrList = (List)params.get("txHashList");
            ArrayList<NulsHash> txHashList = new ArrayList<NulsHash>();
            for (String hashStr : txHashStrList) {
                txHashList.add(NulsHash.fromHex((String)hashStr));
            }
            result = this.confirmedTxService.rollbackTxList(chain, txHashList, (String)params.get("blockHeader"));
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(2);
        resultMap.put("value", result);
        return this.success(resultMap);
    }

    @CmdAnnotation(cmd="tx_getSystemTypes", version=1.0, description="Get all system transaction types/Get system transaction types")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="list", valueType=List.class, valueElement=Integer.class, description="System transaction type collection")}))
    public Response getSystemTypes(Map params) {
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            List<Integer> list = TxManager.getSysTypes(chain);
            HashMap<String, List<Integer>> resultMap = new HashMap<String, List<Integer>>(2);
            resultMap.put("list", list);
            return this.success(resultMap);
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="tx_getTx", version=1.0, description="according tohashObtain transactions, First check for unconfirmed information, Can't find it, check again. Confirmed/Get transaction by tx hash")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="txHash", parameterType="String", parameterDes="Transaction to be queriedhash")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="tx", description="The string of serialized data obtained from the transaction")}))
    public Response getTx(Map params) {
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("txHash"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            String txHash = (String)params.get("txHash");
            if (!NulsHash.validHash((String)txHash)) {
                throw new NulsException(TxErrorCode.HASH_ERROR);
            }
            TransactionConfirmedPO tx = this.txService.getTransaction(chain, NulsHash.fromHex((String)txHash));
            HashMap<String, String> resultMap = new HashMap<String, String>(2);
            if (tx == null) {
                resultMap.put("tx", null);
            } else {
                resultMap.put("tx", RPCUtil.encode((byte[])tx.getTx().serialize()));
            }
            return this.success(resultMap);
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="tx_getConfirmedTx", version=1.0, description="according tohashObtain confirmed transactions(Only check confirmed)/Get confirmed transaction by tx hash")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="txHash", parameterType="String", parameterDes="Transaction to be queriedhash")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="tx", description="The string of serialized data obtained from the transaction")}))
    public Response getConfirmedTx(Map params) {
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("txHash"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            String txHash = (String)params.get("txHash");
            if (!NulsHash.validHash((String)txHash)) {
                throw new NulsException(TxErrorCode.HASH_ERROR);
            }
            TransactionConfirmedPO tx = this.confirmedTxService.getConfirmedTransaction(chain, NulsHash.fromHex((String)txHash));
            HashMap<String, String> resultMap = new HashMap<String, String>(2);
            if (tx == null) {
                resultMap.put("tx", null);
            } else {
                resultMap.put("tx", RPCUtil.encode((byte[])tx.getTx().serialize()));
            }
            return this.success(resultMap);
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="tx_isConfirmed", version=1.0, description="according tohashObtain whether the transaction has been confirmed(Only check confirmed)/Check tx is confirmed by tx hash")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="txHash", parameterType="String", parameterDes="Transaction to be queriedhash")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="true: confirmed; false:unconfirmed")}))
    public Response isConfirmed(Map params) {
        Chain chain = null;
        try {
            Transaction tx;
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("txHash"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            String txHash = (String)params.get("txHash");
            if (!NulsHash.validHash((String)txHash)) {
                throw new NulsException(TxErrorCode.HASH_ERROR);
            }
            TransactionConfirmedPO txPO = this.confirmedTxService.getConfirmedTransaction(chain, NulsHash.fromHex((String)txHash));
            HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(2);
            resultMap.put("value", false);
            if (txPO != null && null != (tx = txPO.getTx()) && txHash.equals(tx.getHash().toHex())) {
                resultMap.put("value", true);
            }
            return this.success(resultMap);
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="tx_getBlockTxs", version=1.0, description="Obtain the complete transaction of the block. If no query is found, or if the query does not include the complete transaction data of the block, return an empty set/Get block transactions")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="txHashList", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="Transaction to be queriedhashaggregate")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txList", valueType=List.class, valueElement=String.class, description="Returns a collection of transaction serialization data strings")}))
    public Response getBlockTxs(Map params) {
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("txHashList"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            List txHashList = (List)params.get("txHashList");
            List<String> txList = this.confirmedTxService.getTxList(chain, txHashList);
            HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>(2);
            resultMap.put("txList", txList);
            return this.success(resultMap);
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="tx_getBlockTxsExtend", version=1.0, description="according tohashList, obtain transactions, check for unconfirmed first, then check for confirmed/Get transactions by hashs")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="txHashList", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="Transaction to be queriedhashaggregate"), @Parameter(parameterName="allHits", requestType=@TypeDescriptor(value=boolean.class), parameterDes="true\uff1aAll data must be found before returning, otherwise return emptylist\uff1b false\uff1aHow many were found and how many were returned")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txList", valueType=List.class, valueElement=String.class, description="Returns a collection of transaction serialization data strings")}))
    public Response getBlockTxsExtend(Map params) {
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("txHashList"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("allHits"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            List txHashList = (List)params.get("txHashList");
            boolean allHits = (Boolean)params.get("allHits");
            List<String> txList = this.confirmedTxService.getTxListExtend(chain, txHashList, allHits);
            HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>(2);
            resultMap.put("txList", txList);
            return this.success(resultMap);
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="tx_getNonexistentUnconfirmedHashs", version=1.0, description="Query incoming transactionshashin,Transactions that are not in the unconfirmed databasehash/Get nonexistent unconfirmed transaction hashs")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="txHashList", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="Transaction to be queriedhashaggregate")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txList", valueType=List.class, valueElement=String.class, description="Returns a collection of transaction serialization data strings")}))
    public Response getNonexistentUnconfirmedHashs(Map params) {
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("txHashList"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            List txHashList = (List)params.get("txHashList");
            List<String> hashList = this.confirmedTxService.getNonexistentUnconfirmedHashList(chain, txHashList);
            HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>(2);
            resultMap.put("txHashList", hashList);
            return this.success(resultMap);
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="tx_batchVerify", priority=CmdPriority.HIGH, version=1.0, description="Verify all transactions in the block/Verify all transactions in the block")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="txList", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="Collection of serialized data strings for transactions to be verified"), @Parameter(parameterName="blockHeader", parameterType="String", parameterDes="Corresponding block header"), @Parameter(parameterName="preStateRoot", parameterType="String", parameterDes="Previous block state root")})
    @ResponseData(name="Return value", description="Return aMap, including twokey", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Verified successfully"), @Key(name="contractList", valueType=List.class, valueElement=String.class, description="New transactions generated by smart contracts")}))
    public Response batchVerify(Map params) {
        Object verifyLedgerResult = null;
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("txList"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("blockHeader"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("preStateRoot"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            List txList = (List)params.get("txList");
            String blockHeaderStr = (String)params.get("blockHeader");
            BlockHeader blockHeader = (BlockHeader)TxUtil.getInstanceRpcStr(blockHeaderStr, BlockHeader.class);
            String preStateRoot = (String)params.get("preStateRoot");
            Map<String, Object> resultMap = ProtocolGroupManager.getCurrentVersion((int)chain.getChainId()) >= TxContext.UPDATE_VERSION_CONTRACT_ASSET ? this.txService.batchVerifyV8(chain, txList, blockHeader, blockHeaderStr, preStateRoot) : this.txService.batchVerify(chain, txList, blockHeader, blockHeaderStr, preStateRoot);
            return this.success(resultMap);
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="tx_setContractGenerateTxTypes", priority=CmdPriority.HIGH, version=1.0, description="Set the system transaction type generated by the smart contract module\uff08Including consensus, cross chain, etc\uff1bExcludinggasReturn transaction\uff09")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="txTypeList", requestType=@TypeDescriptor(value=List.class, collectionElement=Integer.class), parameterDes="System transaction types generated by the smart contract module\uff08Including consensus, cross chain, etc\uff1bExcludinggasReturn transaction\uff09")})
    @ResponseData(description="No specific return value, set successfully without errors")
    public Response setContractGenerateTxTypes(Map params) {
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("txTypeList"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            ArrayList txTypeList = (ArrayList)params.get("txTypeList");
            if (txTypeList == null) {
                txTypeList = new ArrayList();
            }
            chain.setContractGenerateTxTypes(new HashSet<Integer>(txTypeList));
            chain.getLogger().info("Set smart contract generation transaction type: {}", new Object[]{Arrays.toString(txTypeList.toArray())});
            return this.success();
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="tx_cs_state", version=1.0, description="Set node packaging status(Set by consensus module)/Set the node packaging state")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="packaging", requestType=@TypeDescriptor(value=boolean.class), parameterDes="Is packaging in progress")})
    @ResponseData(description="No specific return value, set successfully without errors")
    public Response packaging(Map params) {
        Chain chain = null;
        try {
            Boolean packaging;
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            Boolean bl = packaging = null == params.get("packaging") ? null : (Boolean)params.get("packaging");
            if (null == packaging) {
                throw new NulsException(TxErrorCode.PARAMETER_ERROR);
            }
            chain.getPackaging().set(packaging);
            chain.getLogger().debug("Task-Packaging Is the node a packaging node,Status changed to: {}", new Object[]{chain.getPackaging().get()});
            return this.success();
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="tx_bl_state", version=1.0, description="Set node block synchronization status(Set by block module)/Set the node block state")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="status", requestType=@TypeDescriptor(value=int.class), parameterDes="Is waiting entered, Do not process transactions")})
    @ResponseData(description="No specific return value, set successfully without errors")
    public Response blockNotice(Map params) {
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            Integer status = (Integer)params.get("status");
            if (null == status) {
                throw new NulsException(TxErrorCode.PARAMETER_ERROR);
            }
            if (1 == status) {
                chain.getProcessTxStatus().set(true);
                chain.getLogger().info("Node block synchronization status changed to: true");
            } else {
                chain.getProcessTxStatus().set(false);
                chain.getLogger().info("Node block synchronization status changed to: false");
            }
            return this.success();
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="tx_blockHeight", priority=CmdPriority.HIGH, version=1.0, description="Receive the latest block height/Receive the latest block height")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="height", requestType=@TypeDescriptor(value=long.class), parameterDes="block height")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Whether successful")}))
    public Response height(Map params) {
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            Long height = Long.parseLong(params.get("height").toString());
            chain.setBestBlockHeight(height);
            chain.getLogger().debug("The latest confirmed block height update is: [{}]" + TxUtil.nextLine() + TxUtil.nextLine(), new Object[]{height});
            HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(2);
            resultMap.put("value", true);
            return this.success(resultMap);
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="tx_getTxSigners", version=1.0, description="Obtain a list of legitimate signatories for the transaction/Gets the list of signers of the transaction's legal signature")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="txHex", parameterType="String", parameterDes="Transaction String")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=List.class, valueElement=String.class, description="Legal signature account for transactions")}))
    public Object getTxSigners(Map params) {
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("txHex"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            String txHex = (String)params.get("txHex");
            Transaction tx = (Transaction)TxUtil.getInstance(txHex, Transaction.class);
            TransactionSignature transactionSignature = null;
            transactionSignature = tx.isMultiSignTx() ? (TransactionSignature)TxUtil.getInstance(tx.getTransactionSignature(), MultiSignTxSignature.class) : (TransactionSignature)TxUtil.getInstance(tx.getTransactionSignature(), TransactionSignature.class);
            List p2PHKSignatureList = transactionSignature.getP2PHKSignatures();
            HashSet<String> signers = new HashSet<String>();
            if (null != p2PHKSignatureList && !p2PHKSignatureList.isEmpty()) {
                for (P2PHKSignature signature : p2PHKSignatureList) {
                    if (!ECKey.verify((byte[])tx.getHash().getBytes(), (byte[])signature.getSignData().getSignBytes(), (byte[])signature.getPublicKey())) {
                        throw new NulsException((Throwable)new Exception("Transaction signature error !"));
                    }
                    signers.add(AddressTool.getStringAddressByBytes((byte[])AddressTool.getAddress((byte[])signature.getPublicKey(), (int)chain.getChainId())));
                }
            }
            HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>(2);
            map.put("list", signers);
            return this.success(map);
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    private void errorLogProcess(Chain chain, Exception e) {
        if (chain == null) {
            LoggerUtil.LOG.error(e);
        } else {
            chain.getLogger().error(e);
        }
    }
}

