/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.crypto.jce;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;

public final class ECKeyFactory {
    public static final String ALGORITHM = "EC";
    private static final String algorithmAssertionMsg = "Assumed the JRE supports EC key factories";

    private ECKeyFactory() {
    }

    public static KeyFactory getInstance() {
        return Holder.INSTANCE;
    }

    public static KeyFactory getInstance(String provider) throws NoSuchProviderException {
        try {
            return KeyFactory.getInstance(ALGORITHM, provider);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AssertionError(algorithmAssertionMsg, ex);
        }
    }

    public static KeyFactory getInstance(Provider provider) {
        try {
            return KeyFactory.getInstance(ALGORITHM, provider);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AssertionError(algorithmAssertionMsg, ex);
        }
    }

    private static class Holder {
        private static final KeyFactory INSTANCE;

        private Holder() {
        }

        static {
            try {
                INSTANCE = KeyFactory.getInstance(ECKeyFactory.ALGORITHM);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new AssertionError(ECKeyFactory.algorithmAssertionMsg, ex);
            }
        }
    }
}

