/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource;

import java.util.Arrays;
import org.ethereum.crypto.HashUtil;
import org.ethereum.datasource.AbstractChainedSource;
import org.ethereum.datasource.HashedKeySource;
import org.ethereum.datasource.QuotientFilter;
import org.ethereum.datasource.Source;
import org.ethereum.util.ByteUtil;
import org.ethereum.util.RLP;

public class CountingBytesSource
extends AbstractChainedSource<byte[], byte[], byte[], byte[]>
implements HashedKeySource<byte[], byte[]> {
    QuotientFilter filter;
    boolean dirty = false;
    private byte[] filterKey = HashUtil.sha3("countingStateFilter".getBytes());

    public CountingBytesSource(Source<byte[], byte[]> src) {
        this(src, false);
    }

    public CountingBytesSource(Source<byte[], byte[]> src, boolean bloom) {
        super(src);
        byte[] filterBytes = src.get(this.filterKey);
        if (bloom) {
            this.filter = filterBytes != null ? QuotientFilter.deserialize(filterBytes) : QuotientFilter.create(5000000L, 10000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(byte[] key, byte[] val) {
        if (val == null) {
            this.delete(key);
            return;
        }
        CountingBytesSource countingBytesSource = this;
        synchronized (countingBytesSource) {
            byte[] srcVal = (byte[])this.getSource().get(key);
            int srcCount = this.decodeCount(srcVal);
            if (srcCount >= 1) {
                if (this.filter != null) {
                    this.filter.insert(key);
                }
                this.dirty = true;
            }
            this.getSource().put(key, this.encodeCount(val, srcCount + 1));
        }
    }

    @Override
    public byte[] get(byte[] key) {
        return this.decodeValue((byte[])this.getSource().get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(byte[] key) {
        CountingBytesSource countingBytesSource = this;
        synchronized (countingBytesSource) {
            int srcCount;
            byte[] srcVal = null;
            if (this.filter == null || this.filter.maybeContains(key)) {
                srcVal = (byte[])this.getSource().get(key);
                srcCount = this.decodeCount(srcVal);
            } else {
                srcCount = 1;
            }
            if (srcCount > 1) {
                this.getSource().put(key, this.encodeCount(this.decodeValue(srcVal), srcCount - 1));
            } else {
                this.getSource().delete(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean flushImpl() {
        if (this.filter != null && this.dirty) {
            byte[] filterBytes;
            CountingBytesSource countingBytesSource = this;
            synchronized (countingBytesSource) {
                filterBytes = this.filter.serialize();
            }
            this.getSource().put(this.filterKey, filterBytes);
            this.dirty = false;
            return true;
        }
        return false;
    }

    protected byte[] decodeValue(byte[] srcVal) {
        return srcVal == null ? null : Arrays.copyOfRange(srcVal, RLP.decode(srcVal, 0).getPos(), srcVal.length);
    }

    protected int decodeCount(byte[] srcVal) {
        return srcVal == null ? 0 : ByteUtil.byteArrayToInt((byte[])RLP.decode(srcVal, 0).getDecoded());
    }

    protected byte[] encodeCount(byte[] val, int count) {
        return ByteUtil.merge(RLP.encodeInt(count), val);
    }
}

