/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource;

import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.ethereum.util.ByteUtil;

public class QuotientFilter
implements Iterable<Long> {
    byte QUOTIENT_BITS;
    byte REMAINDER_BITS;
    byte ELEMENT_BITS;
    long INDEX_MASK;
    long REMAINDER_MASK;
    long ELEMENT_MASK;
    long MAX_SIZE;
    long MAX_INSERTIONS;
    int MAX_DUPLICATES = 2;
    long[] table;
    boolean overflowed = false;
    long entries;

    public static QuotientFilter deserialize(byte[] bytes) {
        QuotientFilter ret = new QuotientFilter();
        ret.QUOTIENT_BITS = bytes[0];
        ret.REMAINDER_BITS = bytes[1];
        ret.ELEMENT_BITS = bytes[2];
        ret.INDEX_MASK = ByteUtil.byteArrayToLong(Arrays.copyOfRange(bytes, 3, 11));
        ret.REMAINDER_MASK = ByteUtil.byteArrayToLong(Arrays.copyOfRange(bytes, 11, 19));
        ret.ELEMENT_MASK = ByteUtil.byteArrayToLong(Arrays.copyOfRange(bytes, 19, 27));
        ret.MAX_SIZE = ByteUtil.byteArrayToLong(Arrays.copyOfRange(bytes, 27, 35));
        ret.MAX_INSERTIONS = ByteUtil.byteArrayToLong(Arrays.copyOfRange(bytes, 35, 43));
        ret.overflowed = bytes[43] > 0;
        ret.entries = ByteUtil.byteArrayToLong(Arrays.copyOfRange(bytes, 44, 52));
        ret.table = new long[(bytes.length - 52) / 8];
        for (int i = 0; i < ret.table.length; ++i) {
            ret.table[i] = ByteUtil.byteArrayToLong(Arrays.copyOfRange(bytes, 52 + i * 8, 52 + i * 8 + 8));
        }
        return ret;
    }

    public synchronized byte[] serialize() {
        byte[] ret = new byte[52 + this.table.length * 8];
        ret[0] = this.QUOTIENT_BITS;
        ret[1] = this.REMAINDER_BITS;
        ret[2] = this.ELEMENT_BITS;
        System.arraycopy(ByteUtil.longToBytes(this.INDEX_MASK), 0, ret, 3, 8);
        System.arraycopy(ByteUtil.longToBytes(this.REMAINDER_MASK), 0, ret, 11, 8);
        System.arraycopy(ByteUtil.longToBytes(this.ELEMENT_MASK), 0, ret, 19, 8);
        System.arraycopy(ByteUtil.longToBytes(this.MAX_SIZE), 0, ret, 27, 8);
        System.arraycopy(ByteUtil.longToBytes(this.MAX_INSERTIONS), 0, ret, 35, 8);
        ret[43] = (byte)(this.overflowed ? 1 : 0);
        System.arraycopy(ByteUtil.longToBytes(this.entries), 0, ret, 44, 8);
        for (int i = 0; i < this.table.length; ++i) {
            System.arraycopy(ByteUtil.longToBytes(this.table[i]), 0, ret, 52 + i * 8, 8);
        }
        return ret;
    }

    static long LOW_MASK(long n) {
        return (1L << (int)n) - 1L;
    }

    static int TABLE_SIZE(int quotientBits, int remainderBits) {
        long bits = (1L << quotientBits) * (long)(remainderBits + 3);
        long longs = bits / 64L;
        return Ints.checkedCast((long)(bits % 64L > 0L ? longs + 1L : longs));
    }

    static int bitsForNumElementsWithLoadFactor(long numElements) {
        int candidateBits;
        if (numElements == 0L) {
            return 1;
        }
        int n = candidateBits = Long.bitCount(numElements) == 1 ? Math.max(1, Long.numberOfTrailingZeros(numElements)) : Long.numberOfTrailingZeros(Long.highestOneBit(numElements) << 1);
        if ((long)((double)LongMath.pow((long)2L, (int)candidateBits) * 0.75) < numElements) {
            ++candidateBits;
        }
        return candidateBits;
    }

    public static QuotientFilter create(long largestNumberOfElements, long startingElements) {
        Preconditions.checkArgument((largestNumberOfElements >= startingElements ? 1 : 0) != 0);
        Preconditions.checkArgument((startingElements > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((largestNumberOfElements > 0L ? 1 : 0) != 0);
        int quotientBits = QuotientFilter.bitsForNumElementsWithLoadFactor(startingElements);
        int remainderBits = QuotientFilter.bitsForNumElementsWithLoadFactor(largestNumberOfElements);
        remainderBits += 8;
        return new QuotientFilter(quotientBits, remainderBits -= quotientBits);
    }

    private QuotientFilter() {
    }

    public QuotientFilter(int quotientBits, int remainderBits) {
        Preconditions.checkArgument((quotientBits > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((remainderBits > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((quotientBits + remainderBits <= 64 ? 1 : 0) != 0);
        this.QUOTIENT_BITS = (byte)quotientBits;
        this.REMAINDER_BITS = (byte)remainderBits;
        this.ELEMENT_BITS = (byte)(this.REMAINDER_BITS + 3);
        this.INDEX_MASK = QuotientFilter.LOW_MASK(this.QUOTIENT_BITS);
        this.REMAINDER_MASK = QuotientFilter.LOW_MASK(this.REMAINDER_BITS);
        this.ELEMENT_MASK = QuotientFilter.LOW_MASK(this.ELEMENT_BITS);
        this.MAX_SIZE = 1L << this.QUOTIENT_BITS;
        this.MAX_INSERTIONS = (long)((double)this.MAX_SIZE * 0.75);
        this.table = new long[QuotientFilter.TABLE_SIZE(this.QUOTIENT_BITS, this.REMAINDER_BITS)];
        this.entries = 0L;
    }

    public QuotientFilter withMaxDuplicates(int maxDuplicates) {
        this.MAX_DUPLICATES = maxDuplicates;
        return this;
    }

    long getElement(long idx) {
        long elt = 0L;
        long bitpos = (long)this.ELEMENT_BITS * idx;
        int tabpos = Ints.checkedCast((long)(bitpos / 64L));
        long slotpos = bitpos % 64L;
        long spillbits = slotpos + (long)this.ELEMENT_BITS - 64L;
        elt = this.table[tabpos] >>> (int)slotpos & this.ELEMENT_MASK;
        if (spillbits > 0L) {
            long x = this.table[++tabpos] & QuotientFilter.LOW_MASK(spillbits);
            elt |= x << (int)((long)this.ELEMENT_BITS - spillbits);
        }
        return elt;
    }

    void setElement(long idx, long elt) {
        long bitpos = (long)this.ELEMENT_BITS * idx;
        int tabpos = Ints.checkedCast((long)(bitpos / 64L));
        long slotpos = bitpos % 64L;
        long spillbits = slotpos + (long)this.ELEMENT_BITS - 64L;
        int n = tabpos;
        this.table[n] = this.table[n] & (this.ELEMENT_MASK << (int)slotpos ^ 0xFFFFFFFFFFFFFFFFL);
        int n2 = tabpos++;
        this.table[n2] = this.table[n2] | (elt &= this.ELEMENT_MASK) << (int)slotpos;
        if (spillbits > 0L) {
            int n3 = tabpos;
            this.table[n3] = this.table[n3] & (QuotientFilter.LOW_MASK(spillbits) ^ 0xFFFFFFFFFFFFFFFFL);
            int n4 = tabpos;
            this.table[n4] = this.table[n4] | elt >>> (int)((long)this.ELEMENT_BITS - spillbits);
        }
    }

    long incrementIndex(long idx) {
        return idx + 1L & this.INDEX_MASK;
    }

    long decrementIndex(long idx) {
        return idx - 1L & this.INDEX_MASK;
    }

    static boolean isElementOccupied(long elt) {
        return (elt & 1L) != 0L;
    }

    static long setElementOccupied(long elt) {
        return elt | 1L;
    }

    static long clearElementOccupied(long elt) {
        return elt & 0xFFFFFFFFFFFFFFFEL;
    }

    static boolean isElementContinuation(long elt) {
        return (elt & 2L) != 0L;
    }

    static long setElementContinuation(long elt) {
        return elt | 2L;
    }

    static long clearElementContinuation(long elt) {
        return elt & 0xFFFFFFFFFFFFFFFDL;
    }

    static boolean isElementShifted(long elt) {
        return (elt & 4L) != 0L;
    }

    static long setElementShifted(long elt) {
        return elt | 4L;
    }

    static long clearElementShifted(long elt) {
        return elt & 0xFFFFFFFFFFFFFFFBL;
    }

    static long getElementRemainder(long elt) {
        return elt >>> 3;
    }

    static boolean isElementEmpty(long elt) {
        return (elt & 7L) == 0L;
    }

    static boolean isElementClusterStart(long elt) {
        return QuotientFilter.isElementOccupied(elt) & !QuotientFilter.isElementContinuation(elt) & !QuotientFilter.isElementShifted(elt);
    }

    static boolean isElementRunStart(long elt) {
        return !QuotientFilter.isElementContinuation(elt) & (QuotientFilter.isElementOccupied(elt) | QuotientFilter.isElementShifted(elt));
    }

    long hashToQuotient(long hash) {
        return hash >>> this.REMAINDER_BITS & this.INDEX_MASK;
    }

    long hashToRemainder(long hash) {
        return hash & this.REMAINDER_MASK;
    }

    long findRunIndex(long fq) {
        long b = fq;
        while (QuotientFilter.isElementShifted(this.getElement(b))) {
            b = this.decrementIndex(b);
        }
        long s = b;
        while (b != fq) {
            while (QuotientFilter.isElementContinuation(this.getElement(s = this.incrementIndex(s)))) {
            }
            while (!QuotientFilter.isElementOccupied(this.getElement(b = this.incrementIndex(b)))) {
            }
        }
        return s;
    }

    void insertInto(long s, long elt) {
        boolean empty;
        long curr = elt;
        do {
            long prev;
            if (!(empty = QuotientFilter.isElementEmpty(prev = this.getElement(s))) && QuotientFilter.isElementOccupied(prev = QuotientFilter.setElementShifted(prev))) {
                curr = QuotientFilter.setElementOccupied(curr);
                prev = QuotientFilter.clearElementOccupied(prev);
            }
            this.setElement(s, curr);
            curr = prev;
            s = this.incrementIndex(s);
        } while (!empty);
    }

    public boolean overflowed() {
        return this.overflowed;
    }

    protected long hash(byte[] bytes) {
        return ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
    }

    public synchronized void insert(byte[] hash) {
        this.insert(this.hash(hash));
    }

    public synchronized void insert(long hash) {
        long start;
        if (this.maybeContainsXTimes(hash, this.MAX_DUPLICATES)) {
            return;
        }
        if (this.entries >= this.MAX_INSERTIONS | this.overflowed) {
            if (this.overflowed) {
                throw new OverflowedError();
            }
            if (this.REMAINDER_BITS > 1) {
                this.selfResizeDouble();
            } else {
                this.overflowed = true;
                throw new OverflowedError();
            }
        }
        long fq = this.hashToQuotient(hash);
        long fr = this.hashToRemainder(hash);
        long T_fq = this.getElement(fq);
        long entry = fr << 3 & 0xFFFFFFFFFFFFFFF8L;
        if (QuotientFilter.isElementEmpty(T_fq)) {
            this.setElement(fq, QuotientFilter.setElementOccupied(entry));
            ++this.entries;
            return;
        }
        if (!QuotientFilter.isElementOccupied(T_fq)) {
            this.setElement(fq, QuotientFilter.setElementOccupied(T_fq));
        }
        long s = start = this.findRunIndex(fq);
        if (QuotientFilter.isElementOccupied(T_fq)) {
            long rem;
            while ((rem = QuotientFilter.getElementRemainder(this.getElement(s))) < fr && QuotientFilter.isElementContinuation(this.getElement(s = this.incrementIndex(s)))) {
            }
            if (s == start) {
                long old_head = this.getElement(start);
                this.setElement(start, QuotientFilter.setElementContinuation(old_head));
            } else {
                entry = QuotientFilter.setElementContinuation(entry);
            }
        }
        if (s != fq) {
            entry = QuotientFilter.setElementShifted(entry);
        }
        this.insertInto(s, entry);
        ++this.entries;
    }

    private void selfResizeDouble() {
        QuotientFilter qf = this.resize(this.MAX_INSERTIONS * 2L);
        this.QUOTIENT_BITS = qf.QUOTIENT_BITS;
        this.REMAINDER_BITS = qf.REMAINDER_BITS;
        this.ELEMENT_BITS = qf.ELEMENT_BITS;
        this.INDEX_MASK = qf.INDEX_MASK;
        this.REMAINDER_MASK = qf.REMAINDER_MASK;
        this.ELEMENT_MASK = qf.ELEMENT_MASK;
        this.MAX_SIZE = qf.MAX_SIZE;
        this.MAX_INSERTIONS = qf.MAX_INSERTIONS;
        this.table = qf.table;
        if (qf.entries != this.entries) {
            throw new AssertionError();
        }
    }

    public boolean maybeContains(byte[] hash) {
        return this.maybeContains(this.hash(hash));
    }

    public synchronized boolean maybeContains(long hash) {
        if (this.overflowed) {
            throw new OverflowedError();
        }
        long fq = this.hashToQuotient(hash);
        long fr = this.hashToRemainder(hash);
        long T_fq = this.getElement(fq);
        if (!QuotientFilter.isElementOccupied(T_fq)) {
            return false;
        }
        long s = this.findRunIndex(fq);
        do {
            long rem;
            if ((rem = QuotientFilter.getElementRemainder(this.getElement(s))) == fr) {
                return true;
            }
            if (rem <= fr) continue;
            return false;
        } while (QuotientFilter.isElementContinuation(this.getElement(s = this.incrementIndex(s))));
        return false;
    }

    public synchronized boolean maybeContainsXTimes(long hash, int num) {
        if (this.overflowed) {
            throw new OverflowedError();
        }
        long fq = this.hashToQuotient(hash);
        long fr = this.hashToRemainder(hash);
        long T_fq = this.getElement(fq);
        if (!QuotientFilter.isElementOccupied(T_fq)) {
            return false;
        }
        long s = this.findRunIndex(fq);
        int counter = 0;
        do {
            long rem;
            if ((rem = QuotientFilter.getElementRemainder(this.getElement(s))) == fr) {
                ++counter;
                continue;
            }
            if (rem > fr) break;
        } while (QuotientFilter.isElementContinuation(this.getElement(s = this.incrementIndex(s))));
        return counter >= num;
    }

    void deleteEntry(long s, long quot) {
        long curr = this.getElement(s);
        long sp = this.incrementIndex(s);
        long orig = s;
        while (true) {
            long next = this.getElement(sp);
            boolean curr_occupied = QuotientFilter.isElementOccupied(curr);
            if (QuotientFilter.isElementEmpty(next) | QuotientFilter.isElementClusterStart(next) | sp == orig) {
                this.setElement(s, 0L);
                return;
            }
            long updated_next = next;
            if (QuotientFilter.isElementRunStart(next)) {
                while (!QuotientFilter.isElementOccupied(this.getElement(quot = this.incrementIndex(quot)))) {
                }
                if (curr_occupied && quot == s) {
                    updated_next = QuotientFilter.clearElementShifted(next);
                }
            }
            this.setElement(s, curr_occupied ? QuotientFilter.setElementOccupied(updated_next) : QuotientFilter.clearElementOccupied(updated_next));
            s = sp;
            sp = this.incrementIndex(sp);
            curr = next;
        }
    }

    public void remove(byte[] hash) {
        this.remove(this.hash(hash));
    }

    public synchronized void remove(long hash) {
        long next;
        long rem;
        long start;
        if (this.maybeContainsXTimes(hash, this.MAX_DUPLICATES)) {
            return;
        }
        if (this.overflowed) {
            throw new OverflowedError();
        }
        long fq = this.hashToQuotient(hash);
        long fr = this.hashToRemainder(hash);
        long T_fq = this.getElement(fq);
        if (!QuotientFilter.isElementOccupied(T_fq) | this.entries == 0L) {
            throw new NoSuchElementError();
        }
        long s = start = this.findRunIndex(fq);
        while ((rem = QuotientFilter.getElementRemainder(this.getElement(s))) != fr) {
            if (rem > fr) {
                return;
            }
            if (QuotientFilter.isElementContinuation(this.getElement(s = this.incrementIndex(s)))) continue;
        }
        if (rem != fr) {
            throw new NoSuchElementError();
        }
        long kill = s == fq ? T_fq : this.getElement(s);
        boolean replace_run_start = QuotientFilter.isElementRunStart(kill);
        if (QuotientFilter.isElementRunStart(kill) && !QuotientFilter.isElementContinuation(next = this.getElement(this.incrementIndex(s)))) {
            T_fq = QuotientFilter.clearElementOccupied(T_fq);
            this.setElement(fq, T_fq);
        }
        this.deleteEntry(s, fq);
        if (replace_run_start) {
            long updated_next = next = this.getElement(s);
            if (QuotientFilter.isElementContinuation(next)) {
                updated_next = QuotientFilter.clearElementContinuation(next);
            }
            if (s == fq && QuotientFilter.isElementRunStart(updated_next)) {
                updated_next = QuotientFilter.clearElementShifted(updated_next);
            }
            if (updated_next != next) {
                this.setElement(s, updated_next);
            }
        }
        --this.entries;
    }

    public QuotientFilter resize(long minimumEntries) {
        if (minimumEntries <= this.MAX_INSERTIONS) {
            return this;
        }
        int newQuotientBits = QuotientFilter.bitsForNumElementsWithLoadFactor(minimumEntries);
        int newRemainderBits = this.QUOTIENT_BITS + this.REMAINDER_BITS - newQuotientBits;
        if (newRemainderBits < 1) {
            throw new IllegalArgumentException("Not enough fingerprint bits to resize");
        }
        QuotientFilter qf = new QuotientFilter(newQuotientBits, newRemainderBits);
        QFIterator i = new QFIterator();
        while (i.hasNext()) {
            qf.insert(i.nextPrimitive());
        }
        return qf;
    }

    public int getAllocatedBytes() {
        return this.table.length << 3;
    }

    public void clear() {
        this.entries = 0L;
        Arrays.fill(this.table, 0L);
    }

    public QFIterator iterator() {
        return new QFIterator();
    }

    public static interface LongIterator
    extends Iterator<Long> {
        public long nextPrimitive();

        @Override
        public Long next();
    }

    public class NoSuchElementError
    extends AssertionError {
    }

    public class OverflowedError
    extends AssertionError {
    }

    class QFIterator
    implements LongIterator {
        long index;
        long quotient;
        long visited;

        QFIterator() {
            long start;
            this.visited = QuotientFilter.this.entries;
            if (QuotientFilter.this.entries == 0L) {
                return;
            }
            for (start = 0L; start < QuotientFilter.this.MAX_SIZE && !QuotientFilter.isElementClusterStart(QuotientFilter.this.getElement(start)); ++start) {
            }
            this.visited = 0L;
            this.index = start;
        }

        @Override
        public boolean hasNext() {
            return QuotientFilter.this.entries != this.visited;
        }

        @Override
        public Long next() {
            return this.nextPrimitive();
        }

        @Override
        public void remove() {
        }

        @Override
        public long nextPrimitive() {
            while (this.hasNext()) {
                long quot;
                long elt = QuotientFilter.this.getElement(this.index);
                if (QuotientFilter.isElementClusterStart(elt)) {
                    this.quotient = this.index;
                } else if (QuotientFilter.isElementRunStart(elt)) {
                    quot = this.quotient;
                    while (!QuotientFilter.isElementOccupied(QuotientFilter.this.getElement(quot = QuotientFilter.this.incrementIndex(quot)))) {
                    }
                    this.quotient = quot;
                }
                this.index = QuotientFilter.this.incrementIndex(this.index);
                if (QuotientFilter.isElementEmpty(elt)) continue;
                quot = this.quotient;
                long rem = QuotientFilter.getElementRemainder(elt);
                long hash = quot << QuotientFilter.this.REMAINDER_BITS | rem;
                ++this.visited;
                return hash;
            }
            throw new NoSuchElementException();
        }
    }
}

