/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource.inmem;

import java.util.Map;
import java.util.Set;
import org.ethereum.datasource.DbSettings;
import org.ethereum.datasource.DbSource;
import org.ethereum.util.ByteArrayMap;
import org.ethereum.util.FastByteComparisons;

public class HashMapDBSimple<V>
implements DbSource<V> {
    protected final Map<byte[], V> storage;

    public HashMapDBSimple() {
        this(new ByteArrayMap());
    }

    public HashMapDBSimple(ByteArrayMap<V> storage) {
        this.storage = storage;
    }

    @Override
    public void put(byte[] key, V val) {
        if (val == null) {
            this.delete(key);
        } else {
            this.storage.put(key, val);
        }
    }

    @Override
    public V get(byte[] key) {
        return this.storage.get(key);
    }

    @Override
    public void delete(byte[] key) {
        this.storage.remove(key);
    }

    @Override
    public boolean flush() {
        return true;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public String getName() {
        return "in-memory";
    }

    @Override
    public void init() {
    }

    @Override
    public void init(DbSettings settings) {
    }

    @Override
    public boolean isAlive() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public Set<byte[]> keys() {
        return this.getStorage().keySet();
    }

    @Override
    public void reset() {
        this.storage.clear();
    }

    @Override
    public V prefixLookup(byte[] key, int prefixBytes) {
        for (Map.Entry<byte[], V> e : this.storage.entrySet()) {
            if (FastByteComparisons.compareTo(key, 0, prefixBytes, e.getKey(), 0, prefixBytes) != 0) continue;
            return e.getValue();
        }
        return null;
    }

    @Override
    public void updateBatch(Map<byte[], V> rows) {
        for (Map.Entry<byte[], V> entry : rows.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Map<byte[], V> getStorage() {
        return this.storage;
    }
}

