/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.db;

import java.io.Serializable;
import java.util.Arrays;
import org.ethereum.util.ByteUtil;
import org.ethereum.util.FastByteComparisons;

public class ByteArrayWrapper
implements Comparable<ByteArrayWrapper>,
Serializable {
    private final byte[] data;
    private int hashCode = 0;

    public ByteArrayWrapper(byte[] data) {
        if (data == null) {
            throw new NullPointerException("Data must not be null");
        }
        this.data = data;
        this.hashCode = Arrays.hashCode(data);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ByteArrayWrapper)) {
            return false;
        }
        byte[] otherData = ((ByteArrayWrapper)other).getData();
        return FastByteComparisons.compareTo(this.data, 0, this.data.length, otherData, 0, otherData.length) == 0;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(ByteArrayWrapper o) {
        return FastByteComparisons.compareTo(this.data, 0, this.data.length, o.getData(), 0, o.getData().length);
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return ByteUtil.toHexString(this.data);
    }
}

