/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.db;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.ethereum.config.SystemProperties;
import org.ethereum.core.Block;
import org.ethereum.core.BlockHeader;
import org.ethereum.datasource.JournalSource;
import org.ethereum.datasource.Source;
import org.ethereum.db.IndexedBlockStore;
import org.ethereum.db.StateSource;
import org.ethereum.db.prune.Pruner;
import org.ethereum.db.prune.Segment;

public class PruneManager {
    private static final int LONGEST_CHAIN = 192;
    private JournalSource<?> journalSource;
    private IndexedBlockStore blockStore;
    private int pruneBlocksCnt;
    private Segment segment;
    private Pruner pruner;

    private PruneManager(SystemProperties config) {
        this.pruneBlocksCnt = config.databasePruneDepth();
    }

    public PruneManager(IndexedBlockStore blockStore, JournalSource<?> journalSource, Source<byte[], ?> pruneStorage, int pruneBlocksCnt) {
        this.blockStore = blockStore;
        this.journalSource = journalSource;
        this.pruneBlocksCnt = pruneBlocksCnt;
        if (journalSource != null && pruneStorage != null) {
            this.pruner = new Pruner(journalSource.getJournal(), pruneStorage);
        }
    }

    public void setStateSource(StateSource stateSource) {
        this.journalSource = stateSource.getJournalSource();
        if (this.journalSource != null) {
            this.pruner = new Pruner(this.journalSource.getJournal(), stateSource.getNoJournalSource());
        }
    }

    public void blockCommitted(BlockHeader block) {
        long mainBlockNum;
        if (this.pruneBlocksCnt < 0) {
            return;
        }
        JournalSource.Update update = this.journalSource.commitUpdates(block.getHash());
        this.pruner.feed(update);
        long forkBlockNum = block.getNumber() - (long)this.getForkBlocksCnt();
        if (forkBlockNum < 0L) {
            return;
        }
        List<Block> pruneBlocks = this.blockStore.getBlocksByNumber(forkBlockNum);
        Block chainBlock = this.blockStore.getChainBlockByNumber(forkBlockNum);
        if (chainBlock == null) {
            this.segment = null;
            return;
        }
        if (this.segment == null) {
            if (pruneBlocks.size() == 1) {
                this.segment = new Segment(chainBlock);
            }
            return;
        }
        Segment.Tracker tracker = this.segment.startTracking();
        tracker.addMain(chainBlock);
        tracker.addAll(pruneBlocks);
        tracker.commit();
        if (this.segment.isComplete()) {
            if (!this.pruner.isReady()) {
                List<byte[]> forkWindow = this.getAllChainsHashes(this.segment.getRootNumber() + 1L, this.blockStore.getMaxNumber());
                this.pruner.init(forkWindow, this.getForkBlocksCnt());
                int mainChainWindowSize = this.pruneBlocksCnt - this.getForkBlocksCnt();
                if (mainChainWindowSize > 0) {
                    List<byte[]> mainChainWindow = this.getMainChainHashes(Math.max(1L, this.segment.getRootNumber() - (long)mainChainWindowSize + 1L), this.segment.getRootNumber());
                    this.pruner.withSecondStep(mainChainWindow, mainChainWindowSize);
                }
            }
            this.pruner.prune(this.segment);
            this.segment = new Segment(chainBlock);
        }
        if ((mainBlockNum = block.getNumber() - (long)this.getMainBlocksCnt()) < 0L) {
            return;
        }
        byte[] hash = this.blockStore.getBlockHashByNumber(mainBlockNum);
        this.pruner.persist(hash);
    }

    private int getForkBlocksCnt() {
        return Math.min(this.pruneBlocksCnt, 384);
    }

    private int getMainBlocksCnt() {
        if (this.pruneBlocksCnt <= 384) {
            return Integer.MAX_VALUE;
        }
        return this.pruneBlocksCnt;
    }

    private List<byte[]> getAllChainsHashes(long fromBlock, long toBlock) {
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        for (long num = fromBlock; num <= toBlock; ++num) {
            List<Block> blocks = this.blockStore.getBlocksByNumber(num);
            List hashes = blocks.stream().map(Block::getHash).collect(Collectors.toList());
            ret.addAll(hashes);
        }
        return ret;
    }

    private List<byte[]> getMainChainHashes(long fromBlock, long toBlock) {
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        for (long num = fromBlock; num <= toBlock; ++num) {
            byte[] hash = this.blockStore.getBlockHashByNumber(num);
            ret.add(hash);
        }
        return ret;
    }
}

