/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.db;

import io.nuls.contract.util.Log;
import org.ethereum.config.CommonConfig;
import org.ethereum.config.SystemProperties;
import org.ethereum.datasource.AbstractCachedSource;
import org.ethereum.datasource.AsyncWriteCache;
import org.ethereum.datasource.HashedKeySource;
import org.ethereum.datasource.JournalSource;
import org.ethereum.datasource.MemSizeEstimator;
import org.ethereum.datasource.NoDeleteSource;
import org.ethereum.datasource.ReadCache;
import org.ethereum.datasource.Source;
import org.ethereum.datasource.SourceChainBox;
import org.ethereum.datasource.WriteCache;

public class StateSource
extends SourceChainBox<byte[], byte[], byte[], byte[]>
implements HashedKeySource<byte[], byte[]> {
    JournalSource<byte[]> journalSource;
    NoDeleteSource<byte[], byte[]> noDeleteSource;
    ReadCache<byte[], byte[]> readCache;
    AbstractCachedSource<byte[], byte[]> writeCache;

    public StateSource(Source<byte[], byte[]> src, boolean pruningEnabled) {
        super(src);
        long memorySize = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        Log.info("Total RAM\uff1a{} MB", memorySize);
        int maxCapacity = 32768;
        if (memorySize >= 7500L) {
            maxCapacity *= 12;
        } else if (memorySize >= 4500L) {
            maxCapacity *= 6;
        } else if (memorySize >= 2500L) {
            maxCapacity *= 3;
        }
        this.readCache = new ReadCache.BytesKey<byte[]>(src).withMaxCapacity(maxCapacity);
        this.add(this.readCache);
        this.readCache.setFlushSource(true);
        this.writeCache = new AsyncWriteCache<byte[], byte[]>(this.readCache){

            @Override
            protected WriteCache<byte[], byte[]> createCache(Source<byte[], byte[]> source) {
                WriteCache.BytesKey<byte[]> ret = new WriteCache.BytesKey<byte[]>(source, WriteCache.CacheType.SIMPLE);
                ret.withSizeEstimators(MemSizeEstimator.ByteArrayEstimator, MemSizeEstimator.ByteArrayEstimator);
                ret.setFlushSource(true);
                return ret;
            }
        }.withName("state");
        this.add(this.writeCache);
        if (pruningEnabled) {
            this.journalSource = new JournalSource<byte[]>((Source<byte[], byte[]>)this.writeCache);
            this.add(this.journalSource);
        } else {
            this.noDeleteSource = new NoDeleteSource<byte[], byte[]>((Source<byte[], byte[]>)this.writeCache);
            this.add(this.noDeleteSource);
        }
    }

    public void setConfig(SystemProperties config) {
        int size = config.getConfig().getInt("cache.stateCacheSize");
        long memorySize = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        Log.info("Total RAM\uff1a{} MB", memorySize);
        int maxCapacity = size * 1024 * 2;
        if (memorySize >= 7500L) {
            maxCapacity *= 10;
        } else if (memorySize >= 4500L) {
            maxCapacity *= 5;
        } else if (memorySize >= 2500L) {
            maxCapacity *= 2;
        }
        this.readCache.withMaxCapacity(maxCapacity);
    }

    public void setCommonConfig(CommonConfig commonConfig) {
        if (this.journalSource != null) {
            this.journalSource.setJournalStore(commonConfig.cachedDbSource("journal"));
        }
    }

    public JournalSource<byte[]> getJournalSource() {
        return this.journalSource;
    }

    public Source<byte[], byte[]> getNoJournalSource() {
        return this.writeCache;
    }

    public AbstractCachedSource<byte[], byte[]> getWriteCache() {
        return this.writeCache;
    }

    public ReadCache<byte[], byte[]> getReadCache() {
        return this.readCache;
    }
}

