/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.db.prune;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.ethereum.db.prune.ChainItem;

public class Chain {
    static final Chain NULL = new Chain(){

        @Override
        boolean connect(ChainItem item) {
            throw new RuntimeException("Not supported for null chain");
        }
    };
    List<ChainItem> items = new ArrayList<ChainItem>();

    public List<byte[]> getHashes() {
        return this.items.stream().map(item -> item.hash).collect(Collectors.toList());
    }

    private Chain() {
    }

    Chain(ChainItem item) {
        this.items.add(item);
    }

    ChainItem top() {
        return this.items.size() > 0 ? this.items.get(this.items.size() - 1) : null;
    }

    long topNumber() {
        return this.top() != null ? this.top().number : 0L;
    }

    long startNumber() {
        return this.items.isEmpty() ? 0L : this.items.get((int)0).number;
    }

    boolean isHigher(Chain other) {
        return other.topNumber() < this.topNumber();
    }

    boolean contains(ChainItem other) {
        for (ChainItem item : this.items) {
            if (!item.equals(other)) continue;
            return true;
        }
        return false;
    }

    boolean connect(ChainItem item) {
        if (this.top().isParentOf(item)) {
            this.items.add(item);
            return true;
        }
        return false;
    }

    static Chain fromItems(ChainItem ... items) {
        if (items.length == 0) {
            return NULL;
        }
        Chain chain = null;
        for (ChainItem item : items) {
            if (chain == null) {
                chain = new Chain(item);
                continue;
            }
            chain.connect(item);
        }
        return chain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Chain chain = (Chain)o;
        return !(this.items == null ? chain.items != null : !this.items.equals(chain.items));
    }

    public String toString() {
        if (this.items.isEmpty()) {
            return "(empty)";
        }
        return "[" + this.items.get(0) + " ~> " + this.items.get(this.items.size() - 1) + "]";
    }
}

