/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.util;

import java.lang.reflect.Array;
import java.math.BigInteger;
import java.net.URL;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;
import org.ethereum.datasource.DbSource;
import org.ethereum.db.ByteArrayWrapper;
import org.ethereum.util.ByteUtil;
import org.ethereum.vm.DataWord;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final DataWord DIVISOR = DataWord.of(64);
    private static SecureRandom random = new SecureRandom();
    static BigInteger _1000_ = new BigInteger("1000");
    public static double JAVA_VERSION = Utils.getJavaVersion();

    public static BigInteger unifiedNumericToBigInteger(String number) {
        boolean match = Pattern.matches("0[xX][0-9a-fA-F]+", number);
        if (!match) {
            return new BigInteger(number);
        }
        number = (number = number.substring(2)).length() % 2 != 0 ? "0".concat(number) : number;
        byte[] numberBytes = Hex.decode((String)number);
        return new BigInteger(1, numberBytes);
    }

    public static String longToDateTime(long timestamp) {
        Date date = new Date(timestamp * 1000L);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        return formatter.format(date);
    }

    public static String longToTimePeriod(long msec) {
        if (msec < 1000L) {
            return msec + "ms";
        }
        if (msec < 3000L) {
            return String.format("%.2fs", (double)msec / 1000.0);
        }
        if (msec < 60000L) {
            return msec / 1000L + "s";
        }
        long sec = msec / 1000L;
        if (sec < 300L) {
            return sec / 60L + "m" + sec % 60L + "s";
        }
        long min = sec / 60L;
        if (min < 60L) {
            return min + "m";
        }
        long hour = min / 60L;
        if (min < 1440L) {
            return hour + "h" + min % 60L + "m";
        }
        long day = hour / 24L;
        return day + "d" + hour % 24L + "h";
    }

    public static ImageIcon getImageIcon(String resource) {
        URL imageURL = ClassLoader.getSystemResource(resource);
        ImageIcon image = new ImageIcon(imageURL);
        return image;
    }

    public static String getValueShortString(BigInteger number) {
        BigInteger result = number;
        int pow = 0;
        while (result.compareTo(_1000_) == 1 || result.compareTo(_1000_) == 0) {
            result = result.divide(_1000_);
            pow += 3;
        }
        return result.toString() + "\u00b7(10^" + pow + ")";
    }

    public static byte[] addressStringToBytes(String hex) {
        byte[] addr;
        try {
            addr = Hex.decode((String)hex);
        }
        catch (DecoderException addressIsNotValid) {
            return null;
        }
        if (Utils.isValidAddress(addr)) {
            return addr;
        }
        return null;
    }

    public static boolean isValidAddress(byte[] addr) {
        return addr != null && addr.length == 20;
    }

    public static String getAddressShortString(byte[] addr) {
        if (!Utils.isValidAddress(addr)) {
            throw new Error("not an address");
        }
        String addrShort = Hex.toHexString((byte[])addr, (int)0, (int)3);
        StringBuffer sb = new StringBuffer();
        sb.append(addrShort);
        sb.append("...");
        return sb.toString();
    }

    public static SecureRandom getRandom() {
        return random;
    }

    static double getJavaVersion() {
        int pos;
        String version = System.getProperty("java.version");
        if ("0".equals(version)) {
            return 0.0;
        }
        int count = 0;
        for (pos = 0; pos < version.length() && count < 2; ++pos) {
            if (version.charAt(pos) != '.') continue;
            ++count;
        }
        return Double.parseDouble(version.substring(0, pos - 1));
    }

    public static String getHashListShort(List<byte[]> blockHashes) {
        if (blockHashes.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        String firstHash = Hex.toHexString((byte[])blockHashes.get(0));
        String lastHash = Hex.toHexString((byte[])blockHashes.get(blockHashes.size() - 1));
        return sb.append(" ").append(firstHash).append("...").append(lastHash).toString();
    }

    public static String getNodeIdShort(String nodeId) {
        return nodeId == null ? "<null>" : nodeId.substring(0, 8);
    }

    public static long toUnixTime(long javaTime) {
        return javaTime / 1000L;
    }

    public static long fromUnixTime(long unixTime) {
        return unixTime * 1000L;
    }

    public static <T> T[] mergeArrays(T[] ... arr) {
        int size = 0;
        for (T[] ts : arr) {
            size += ts.length;
        }
        Object[] ret = (Object[])Array.newInstance(arr[0].getClass().getComponentType(), size);
        int off = 0;
        for (T[] ts : arr) {
            System.arraycopy(ts, 0, ret, off, ts.length);
            off += ts.length;
        }
        return ret;
    }

    public static String align(String s, char fillChar, int targetLen, boolean alignRight) {
        if (targetLen <= s.length()) {
            return s;
        }
        String alignString = Utils.repeat("" + fillChar, targetLen - s.length());
        return alignRight ? alignString + s : s + alignString;
    }

    public static String repeat(String s, int n) {
        if (s.length() == 1) {
            byte[] bb = new byte[n];
            Arrays.fill(bb, s.getBytes()[0]);
            return new String(bb);
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            ret.append(s);
        }
        return ret.toString();
    }

    public static List<ByteArrayWrapper> dumpKeys(DbSource<byte[]> ds) {
        ArrayList<ByteArrayWrapper> keys = new ArrayList<ByteArrayWrapper>();
        for (byte[] key : ds.keys()) {
            keys.add(ByteUtil.wrap(key));
        }
        Collections.sort(keys);
        return keys;
    }

    public static DataWord allButOne64th(DataWord dw) {
        DataWord divResult = dw.div(DIVISOR);
        return dw.sub(divResult);
    }

    public static void showErrorAndExit(String message, String ... messages) {
        LoggerFactory.getLogger((String)"general").error(message);
        String ANSI_RED = "\u001b[31m";
        String ANSI_RESET = "\u001b[0m";
        System.err.println("\u001b[31m");
        System.err.println("");
        System.err.println("        " + message);
        for (String msg : messages) {
            System.err.println("        " + msg);
        }
        System.err.println("");
        System.err.println("\u001b[0m");
        throw new RuntimeException(message);
    }

    public static void showWarn(String message, String ... messages) {
        LoggerFactory.getLogger((String)"general").warn(message);
        String ANSI_RED = "\u001b[31m";
        String ANSI_RESET = "\u001b[0m";
        System.err.println("\u001b[31m");
        System.err.println("");
        System.err.println("        " + message);
        for (String msg : messages) {
            System.err.println("        " + msg);
        }
        System.err.println("");
        System.err.println("\u001b[0m");
    }

    public static String sizeToStr(long size) {
        if (size < 2048L) {
            return size + "b";
        }
        if (size < 0x200000L) {
            return String.format("%dKb", size / 1024L);
        }
        if (size < 0x80000000L) {
            return String.format("%dMb", size / 0x100000L);
        }
        return String.format("%dGb", size / 0x40000000L);
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean isHexEncoded(String value) {
        if (value == null) {
            return false;
        }
        if ("".equals(value)) {
            return true;
        }
        try {
            new BigInteger(value, 16);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

