/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.config;

import io.nuls.base.api.provider.Provider;
import io.nuls.core.basic.InitializingBean;
import io.nuls.core.core.annotation.Configuration;
import io.nuls.core.core.annotation.Value;
import io.nuls.core.exception.NulsException;
import java.math.BigDecimal;
import java.math.BigInteger;

@Configuration(domain="cmd-client")
public class Config
implements InitializingBean {
    private Integer mainChainId;
    @Value.NotNull
    private Integer chainId;
    @Value.NotNull
    private Integer assetsId;
    private Integer decimals;
    @Value.NotNull
    private Provider.ProviderType providerType;
    private String addressPrefix;
    private String language;
    @Value(value="packageVersion")
    private String clientVersion;

    public String getAddressPrefix() {
        return this.addressPrefix;
    }

    public void setAddressPrefix(String addressPrefix) {
        this.addressPrefix = addressPrefix;
    }

    public boolean isMainChain() {
        return this.chainId.equals(this.mainChainId);
    }

    public Integer getChainId() {
        return this.chainId;
    }

    public void setChainId(Integer chainId) {
        this.chainId = chainId;
    }

    public Integer getAssetsId() {
        return this.assetsId;
    }

    public void setAssetsId(Integer assetsId) {
        this.assetsId = assetsId;
    }

    public Provider.ProviderType getProviderType() {
        return this.providerType;
    }

    public void setProviderType(Provider.ProviderType providerType) {
        this.providerType = providerType;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public Integer getMainChainId() {
        return this.mainChainId;
    }

    public void setMainChainId(Integer mainChainId) {
        this.mainChainId = mainChainId;
    }

    public void afterPropertiesSet() throws NulsException {
    }

    public Integer getDecimals() {
        return this.decimals;
    }

    public void setDecimals(Integer decimals) {
        this.decimals = decimals;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public BigDecimal toBigUnit(BigInteger val) {
        return this.toBigUnit(val, this.getDecimals());
    }

    public BigDecimal toBigUnit(BigInteger val, int decimals) {
        BigDecimal decimal = BigDecimal.TEN.pow(decimals);
        BigDecimal dval = BigDecimal.valueOf(val.longValue());
        return dval.divide(decimal);
    }

    public BigInteger toSmallUnit(BigDecimal val) {
        BigDecimal decimal = BigDecimal.TEN.pow(this.getDecimals());
        return val.multiply(decimal).toBigInteger();
    }

    public BigInteger toSmallUnit(String val) {
        return this.toSmallUnit(new BigDecimal(val));
    }
}

