/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.account;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.account.facade.UpdatePasswordReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandHelper;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.cmd.client.processor.account.AccountBaseProcessor;
import io.nuls.core.core.annotation.Component;

@Component
public class UpdatePasswordProcessor
extends AccountBaseProcessor
implements CommandProcessor {
    @Override
    public String getCommand() {
        return "resetpwd";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<address> address of the account - Required");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "resetpwd <address> --reset password for account";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 1);
        this.checkAddress(this.config.getChainId(), args[1]);
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        String address = args[1];
        String password = CommandHelper.getPwd("Enter your old password:");
        String newPassword = CommandHelper.getPwd("Enter new password:");
        if (!CommandHelper.confirmPwd(newPassword)) {
            return CommandResult.getFailed("Password confirmation doesn't match the password.Operation abort.");
        }
        UpdatePasswordReq req = new UpdatePasswordReq(address, password, newPassword);
        Result res = this.accountService.updatePassword(req);
        if (res.isFailed()) {
            return CommandResult.getFailed(res);
        }
        return CommandResult.getSuccess("Success");
    }
}

