/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.block;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.block.BlockService;
import io.nuls.base.api.provider.block.facade.GetBlockHeaderByHashReq;
import io.nuls.base.api.provider.block.facade.GetBlockHeaderByHeightReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.CommandGroup;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.core.core.annotation.Component;
import java.util.regex.Matcher;

@Component
public class GetBlockHeaderProcessor
implements CommandProcessor {
    BlockService blockService = (BlockService)ServiceManager.get(BlockService.class);

    @Override
    public String getCommand() {
        return "getblockheader";
    }

    @Override
    public CommandGroup getGroup() {
        return CommandGroup.Block;
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<hash> | <height> get block header by hash or block height - Required");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "getblockheader <hash> | <height>--get the block header with hash or height";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 1);
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        Result result;
        String hash = args[1];
        Matcher matcher = IS_NUMBERIC.matcher(args[1]);
        if (matcher.matches()) {
            Long height = Long.parseLong(args[1]);
            result = this.blockService.getBlockHeaderByHeight(new GetBlockHeaderByHeightReq(height));
        } else {
            result = this.blockService.getBlockHeaderByHash(new GetBlockHeaderByHashReq(hash));
        }
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess(result);
    }
}

