/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.block;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.block.BlockService;
import io.nuls.base.api.provider.block.facade.GetBlockHeaderByHeightReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.CommandGroup;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.core.core.annotation.Component;
import java.util.regex.Matcher;

@Component
public class RollbackProcessor
implements CommandProcessor {
    BlockService blockService = (BlockService)ServiceManager.get(BlockService.class);

    @Override
    public String getCommand() {
        return "rollback";
    }

    @Override
    public CommandGroup getGroup() {
        return CommandGroup.Block;
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<count>   block count - Required");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "rollback <count>  -- Roll back a number of blocks";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 1);
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        String hash = args[1];
        Matcher matcher = IS_NUMBERIC.matcher(args[1]);
        Long height = Long.parseLong(args[1]);
        if (height > 1000L) {
            return CommandResult.getFailed("The count is too big");
        }
        Result result = this.blockService.rollback(new GetBlockHeaderByHeightReq(height));
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess(result);
    }
}

