/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.consensus;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.consensus.facade.CreateMultiSignAgentReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.cmd.client.processor.consensus.ConsensusBaseProcessor;
import io.nuls.core.core.annotation.Component;
import java.math.BigInteger;

@Component
public class CreateMultiSignAgentProcessor
extends ConsensusBaseProcessor
implements CommandProcessor {
    @Override
    public String getCommand() {
        return "createmultisignagent";
    }

    @Override
    public String getHelp() {
        CommandBuilder bulider = new CommandBuilder();
        bulider.newLine(this.getCommandDescription()).newLine("\t<agentAddress>   agent owner address   -required").newLine("\t<packingAddress>    packing address    -required").newLine("\t<commissionRate>    commission rate (10~100), you can have up to 2 valid digits after the decimal point  -required").newLine("\t<deposit>  amount you want to deposit, you can have up to 8 valid digits after the decimal point -required").newLine("\t[signAddress] first sign account -- not required").newLine("\t[rewardAddress]  Billing address    -not required");
        return bulider.toString();
    }

    @Override
    public String getCommandDescription() {
        return "createmultisigneagent <agentAddress> <packingAddress> <commissionRate> <deposit> [signAddress] [rewardAddress] --create a agent";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 4, 5, 6);
        this.checkIsNumeric(args[3], "commissionRate");
        this.checkArgs(() -> {
            BigInteger commission = new BigInteger(args[3]);
            return commission.compareTo(BigInteger.TEN) >= 0 && commission.compareTo(BigInteger.valueOf(100L)) <= 0;
        }, "commission rate (10~100)");
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        Result result;
        String agentAddress = args[1];
        String packingAddress = args[2];
        Integer commissionRate = Integer.parseInt(args[3]);
        BigInteger deposit = this.config.toSmallUnit(args[4]);
        String rewardAddress = null;
        if (args.length == 7) {
            rewardAddress = args[6];
        }
        CreateMultiSignAgentReq req = new CreateMultiSignAgentReq(agentAddress, packingAddress, rewardAddress, commissionRate, deposit);
        if (args.length == 6) {
            String signAddress = args[5];
            String password = this.getPwd();
            req.setSignAddress(signAddress);
            req.setPassword(password);
        }
        if ((result = this.consensusProvider.createAgentForMultiSignAccount(req)).isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess(result);
    }
}

