/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.contract;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.contract.facade.DeleteContractReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandHelper;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.ErrorCodeConstants;
import io.nuls.cmd.client.processor.contract.ContractBaseProcessor;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.StringUtils;

@Component
public class DeleteContractProcessor
extends ContractBaseProcessor {
    @Override
    public String getCommand() {
        return "deletecontract";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<address> contract address -required");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "deletecontract <sender> <address> --delete contract";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 2);
        this.checkAddress(this.config.getChainId(), args[1], args[2]);
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        String sender = args[1];
        if (StringUtils.isBlank((String)sender)) {
            return CommandResult.getFailed(ErrorCodeConstants.PARAM_ERR.getMsg());
        }
        String contractAddress = args[2];
        String password = CommandHelper.getPwd();
        Result result = this.contractProvider.deleteContract(new DeleteContractReq(sender, contractAddress, password));
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getResult(result);
    }
}

