/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.crosschain;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.crosschain.facade.GetCrossTxStateReq;
import io.nuls.base.data.Address;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.crosschain.CrossChainBaseProcessor;
import io.nuls.core.constant.BaseConstant;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.log.Log;
import io.nuls.core.parse.SerializeUtils;
import java.util.HashSet;

@Component
public class GetCrossTxStateProcessor
extends CrossChainBaseProcessor {
    @Override
    public String getCommand() {
        return "getcrosstxstate";
    }

    @Override
    public String getHelp() {
        return new CommandBuilder().newLine(this.getCommandDescription()).newLine("\t<txHash>  tx hash - require").toString();
    }

    @Override
    public String getCommandDescription() {
        return this.getCommand() + " <chainId> <txHash> ";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 1);
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        Integer chainId = this.config.getChainId();
        String txHash = args[1];
        GetCrossTxStateReq req = new GetCrossTxStateReq(chainId, txHash);
        Result result = this.crossChainProvider.getCrossTxState(req);
        Result resultTxInfo = this.crossChainProvider.getCrossTx(req);
        this.signList((Transaction)resultTxInfo.getData());
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        String state = result.getData() + "(0:Unconfirmed  1:MainNetConfirmed  2:Confirmed)";
        return CommandResult.getSuccess(state);
    }

    public void signList(Transaction tx) {
        try {
            TransactionSignature signature = new TransactionSignature();
            signature.parse(tx.getTransactionSignature(), 0);
            Log.debug((String)"txHex:{}", (Object[])new Object[]{HexUtil.encode((byte[])tx.serialize())});
            Log.debug((String)"txType:{}", (Object[])new Object[]{tx.getType()});
            Log.debug((String)"txSignCount:{}", (Object[])new Object[]{signature.getSignersCount()});
            HashSet addressSets = new HashSet();
            Log.debug((String)"signer:");
            signature.getP2PHKSignatures().forEach(sign -> {
                Address address = new Address(this.config.getChainId().intValue(), this.config.getAddressPrefix(), BaseConstant.DEFAULT_ADDRESS_TYPE, SerializeUtils.sha256hash160((byte[])sign.getPublicKey()));
                addressSets.add(address.getBase58());
            });
            addressSets.forEach(addr -> Log.debug((String)"{}", (Object[])new Object[]{addr}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

