/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.crosschain;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.crosschain.facade.RegisterChainReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.crosschain.CrossChainBaseProcessor;
import io.nuls.core.core.annotation.Component;
import java.math.BigInteger;

@Component
public class RegisterCrossChainProcessor
extends CrossChainBaseProcessor {
    public static final BigInteger MAX_MAGIC_NUMBER = BigInteger.valueOf(0xFFFFFFFFL);
    public static final int MAX_BFT_RATIO = 100;
    public static final int MIN_BFT_RATIO = 66;

    @Override
    public String getCommand() {
        return "registercrosschain";
    }

    @Override
    public String getHelp() {
        return new CommandBuilder().newLine(this.getCommandDescription()).newLine("\t<address>  payment main chain address - require").newLine("\t<chainId>  register chain id - require").newLine("\t<chainName>  register chain name - require").newLine("\t<addressPrefix>  register chain address prefix.1-5 char - require").newLine("\t<magicNumber> chain connect magic number - require").newLine("\t<maxSignatureCount> chain cross verifier max number - require").newLine("\t<signatureBFTRatio> cross tx BFT ratio >=66 <=100 - require").newLine("\t<verifierList> verifier address list,split by comma - require").newLine("\t<assetId> register assetId - require").newLine("\t<symbol>  register asset symbol - required").newLine("\t<assetName>  register asset name - required").newLine("\t<initNumber>  register asset circulation - required").newLine("\t[decimalPlaces]  register asset decimal digits,default 8 ").newLine("\t[minAvailableNodeNum]  cross chain tx rely on min node number,default 5 ").toString();
    }

    @Override
    public String getCommandDescription() {
        return this.getCommand() + " <address> <chainId> <chainName> <addressPrefix> <magicNumber> <maxSignatureCount> <signatureBFTRatio> <verifierList> <assetId> <symbol> <assetName> <initNumber> [decimalPlaces] [minAvailableNodeNum]";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 12, 13, 14);
        this.checkAddress(this.config.getMainChainId(), args[1]);
        this.checkIsNumeric(args[2], "chainId");
        this.checkIsNumeric(args[5], "magicNumber");
        BigInteger magicNumber = new BigInteger(args[5]);
        this.checkArgs(magicNumber.min(MAX_MAGIC_NUMBER).equals(magicNumber) && !magicNumber.min(BigInteger.ZERO).equals(magicNumber), "magic number must be greater than 0 is less than " + MAX_MAGIC_NUMBER);
        int signatureBFTRatio = Integer.valueOf(args[7]);
        this.checkArgs(signatureBFTRatio >= 66 && signatureBFTRatio <= 100, "cross tx BFT ratio >=66<=100");
        this.checkIsNumeric(args[6], "maxSignatureCount");
        this.checkIsNumeric(args[7], "signatureBFTRatio");
        this.checkIsNumeric(args[9], "assetId");
        this.checkIsNumeric(args[12], "initNumber");
        if (args.length > 13) {
            this.checkIsNumeric(args[13], "decimalPlaces");
        }
        if (args.length > 14) {
            this.checkIsNumeric(args[14], "minAvailableNodeNum");
        }
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        String address = args[1];
        Integer chainId = Integer.parseInt(args[2]);
        String chainName = args[3];
        String addressPrefix = args[4];
        Long magicNumber = Long.parseLong(args[5]);
        int maxSignatureCount = Integer.parseInt(args[6]);
        int signatureBFTRatio = Integer.parseInt(args[7]);
        String verifierList = args[8];
        Integer assetId = Integer.parseInt(args[9]);
        String symbol = args[10];
        String assetName = args[11];
        Long initNumber = Long.parseLong(args[12]);
        int decimalPlaces = 8;
        int minAvailableNodeNum = 5;
        if (args.length > 13) {
            decimalPlaces = Integer.parseInt(args[13]);
        }
        if (args.length > 14) {
            minAvailableNodeNum = Integer.parseInt(args[14]);
        }
        RegisterChainReq req = new RegisterChainReq(address, chainId, chainName, addressPrefix, magicNumber, maxSignatureCount, signatureBFTRatio, verifierList, assetId.intValue(), symbol, assetName, initNumber, "1", this.getPwd());
        req.setDecimalPlaces(decimalPlaces);
        req.setMinAvailableNodeNum(minAvailableNodeNum);
        Result result = this.chainManageProvider.registerChain(req);
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess(result);
    }
}

