/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.system;

import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandHandler;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.CommandGroup;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.core.core.annotation.Component;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

@Component
public class HelpProcessor
implements CommandProcessor {
    @Override
    public String getCommand() {
        return "help";
    }

    @Override
    public CommandGroup getGroup() {
        return CommandGroup.System;
    }

    @Override
    public String getHelp() {
        CommandBuilder bulider = new CommandBuilder();
        bulider.newLine("help [-a | group | command]").newLine("\t[-a] show all commands and options of command - optional").newLine("\t[group] show commands and options of this group. group list: " + Arrays.stream(CommandGroup.values()).map(g -> g.getTitle().toLowerCase()).collect(Collectors.toList())).newLine("\t[command] shwo this command info ");
        return bulider.toString();
    }

    @Override
    public String getCommandDescription() {
        return "help [-a  -- print all commands info | group -- print command info for this group | command -- print this command info ] ";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 1);
        this.checkArgs("-a".equals(args[1]) || Arrays.stream(CommandGroup.values()).anyMatch(g -> g.getTitle().equals(args[1])) || CommandHandler.PROCESSOR_MAP.values().stream().anyMatch(p -> p.getCommand().equals(args[1])), this.getCommandDescription());
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        StringBuilder str = new StringBuilder();
        if (args.length == 1) {
            Arrays.stream(CommandGroup.values()).forEach(group -> this.printGroup((CommandGroup)((Object)group), str, false));
        } else {
            String cmd = args[1];
            if ("-a".equals(cmd)) {
                Arrays.stream(CommandGroup.values()).forEach(group -> this.printGroup((CommandGroup)((Object)group), str, true));
            } else {
                Optional<CommandGroup> group2 = Arrays.stream(CommandGroup.values()).filter(g -> g.getTitle().equals(cmd)).findFirst();
                if (group2.isPresent()) {
                    this.printGroup(group2.get(), str, true);
                } else {
                    Optional<CommandProcessor> processor = CommandHandler.PROCESSOR_MAP.values().stream().filter(p -> p.getCommand().equals(cmd)).findFirst();
                    if (processor.isPresent()) {
                        this.n(str);
                        this.n(str);
                        str.append(processor.get().getHelp());
                    } else {
                        CommandResult.failed("error cmd");
                    }
                }
            }
        }
        return CommandResult.getSuccess(str.toString());
    }

    private StringBuilder printGroup(CommandGroup group, StringBuilder str, boolean printHelp) {
        this.n(str);
        this.n(str);
        str.append("-------------------------------------------------- ");
        this.n(str);
        str.append("group : ").append(group.getTitle());
        this.n(str);
        str.append("-------------------------------------------------- ");
        this.n(str);
        CommandHandler.PROCESSOR_MAP.values().stream().filter(p -> group.equals((Object)p.getGroup())).forEach(p -> {
            this.n(str);
            if (printHelp) {
                str.append(p.getHelp());
            } else {
                str.append(p.getCommandDescription());
            }
        });
        this.n(str);
        return str;
    }

    private StringBuilder n(StringBuilder buf) {
        return buf.append("\n");
    }
}

