/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.utils;

import io.nuls.cmd.client.processor.ErrorCodeConstants;
import io.nuls.cmd.client.utils.LoggerUtil;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AssetsUtil {
    public static Map<String, Integer> ASSETS_DECIMALS = new HashMap<String, Integer>();

    static String getAssetKey(int chainId, int assetId) {
        return chainId + "-" + assetId;
    }

    public static Integer getCrossAssetDecimal(int chainId, int assetId) {
        Integer val;
        String key = AssetsUtil.getAssetKey(chainId, assetId);
        if (null == ASSETS_DECIMALS.get(key)) {
            AssetsUtil.initRegisteredChainInfo();
        }
        if (null != (val = ASSETS_DECIMALS.get(key))) {
            return val;
        }
        if (chainId == 2 && assetId == 201) {
            return 8;
        }
        if (chainId == 2 && assetId == 202) {
            return 18;
        }
        return null;
    }

    public static Result initRegisteredChainInfo() {
        try {
            Map map = (Map)AssetsUtil.request(ModuleE.CC.abbr, "getRegisteredChainInfoList", null, null);
            List resultList = (List)map.get("list");
            for (Map resultMap : resultList) {
                List assetList = (List)resultMap.get("assetInfoList");
                if (assetList == null) continue;
                for (Map assetMap : assetList) {
                    int chainId = (Integer)resultMap.get("chainId");
                    int assetId = (Integer)assetMap.get("assetId");
                    ASSETS_DECIMALS.put(AssetsUtil.getAssetKey(chainId, assetId), (Integer)assetMap.get("decimalPlaces"));
                }
            }
            return Result.getSuccess(null).setData((Object)map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
    }

    public static Object request(String moduleCode, String cmd, Map params, Long timeout) throws NulsException {
        try {
            Response response;
            try {
                response = null == timeout ? ResponseMessageProcessor.requestAndResponse((String)moduleCode, (String)cmd, (Map)params) : ResponseMessageProcessor.requestAndResponse((String)moduleCode, (String)cmd, (Map)params, (long)timeout);
            }
            catch (Exception e) {
                LoggerUtil.logger.error(e);
                throw new NulsException(CommonCodeConstanst.SYS_UNKOWN_EXCEPTION, e.getMessage());
            }
            if (!response.isSuccess()) {
                String comment = response.getResponseComment();
                if (StringUtils.isBlank((String)comment)) {
                    comment = "";
                }
                String errorCode = response.getResponseErrorCode();
                LoggerUtil.logger.error("Call interface [{}] error, ErrorCode is {}, ResponseComment:{}", new Object[]{cmd, errorCode, response.getResponseComment()});
                if (response.getResponseStatus() == 65536) {
                    if (StringUtils.isBlank((String)errorCode)) {
                        throw new NulsException(CommonCodeConstanst.SYS_UNKOWN_EXCEPTION, comment);
                    }
                    throw new NulsException(ErrorCode.init((String)errorCode), comment);
                }
                if (StringUtils.isNotBlank((String)comment)) {
                    throw new NulsException(CommonCodeConstanst.FAILED, comment);
                }
                throw new NulsException(CommonCodeConstanst.SYS_UNKOWN_EXCEPTION, "unknown error");
            }
            Map data = (Map)response.getResponseData();
            return data.get(cmd);
        }
        catch (Exception e) {
            LoggerUtil.logger.error(e);
            if (e instanceof NulsException) {
                throw (NulsException)((Object)e);
            }
            throw new NulsException(ErrorCodeConstants.SYSTEM_ERR, e.getMessage());
        }
    }

    public static BigDecimal toBigUnit(BigInteger val, Integer decimals) {
        BigDecimal decimal = BigDecimal.TEN.pow(decimals);
        BigDecimal dval = new BigDecimal(val);
        return dval.divide(decimal);
    }
}

