/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rpc.netty.processor;

import io.netty.channel.Channel;
import io.nuls.core.constant.BaseConstant;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.log.Log;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.invoke.BaseInvoke;
import io.nuls.core.rpc.invoke.KernelInvoke;
import io.nuls.core.rpc.model.InvokeBean;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Message;
import io.nuls.core.rpc.model.message.MessageType;
import io.nuls.core.rpc.model.message.MessageUtil;
import io.nuls.core.rpc.model.message.Request;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.model.message.Unsubscribe;
import io.nuls.core.rpc.netty.channel.manager.ConnectManager;
import io.nuls.core.rpc.netty.processor.container.RequestContainer;
import io.nuls.core.rpc.netty.processor.container.ResponseContainer;
import io.nuls.core.rpc.util.LocalModuleCall;
import io.nuls.core.rpc.util.SerializeUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ResponseMessageProcessor {
    private static final Long REGISTER_API_TIME_OUT = 180000L;
    public static final Map<String, InvokeBean> INVOKE_BEAN_MAP = new HashMap<String, InvokeBean>();
    public static final Map<String, String> ROLE_MAPPING = new HashMap<String, String>();
    public static final Map<Integer, String> TX_TYPE_MODULE_MAP = new HashMap<Integer, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean handshake(String url) throws Exception {
        Channel channel = ConnectManager.getConnectByUrl(url);
        if (channel == null) {
            throw new Exception("Kernel not available");
        }
        Message message = MessageUtil.basicMessage(MessageType.NegotiateConnection);
        message.setMessageData(MessageUtil.defaultNegotiateConnection());
        ResponseContainer responseContainer = RequestContainer.putRequest(message.getMessageID());
        ConnectManager.sendMessage(channel, SerializeUtil.getBuffer(JSONUtils.obj2ByteArray((Object)message)));
        try {
            boolean bl = responseContainer.getFuture().get(10000L, TimeUnit.MILLISECONDS) != null;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            RequestContainer.removeResponseContainer(message.getMessageID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean handshake(Channel channel) throws Exception {
        Message message = MessageUtil.basicMessage(MessageType.NegotiateConnection);
        message.setMessageData(MessageUtil.defaultNegotiateConnection());
        ResponseContainer responseContainer = RequestContainer.putRequest(message.getMessageID());
        ConnectManager.sendMessage(channel, SerializeUtil.getBuffer(JSONUtils.obj2ByteArray((Object)message)));
        try {
            boolean bl = responseContainer.getFuture().get(10000L, TimeUnit.MILLISECONDS) != null;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            RequestContainer.removeResponseContainer(message.getMessageID());
        }
    }

    public static void syncKernel(String kernelUrl) throws Exception {
        ResponseMessageProcessor.syncKernel(kernelUrl, new KernelInvoke());
    }

    public static void syncKernel(String kernelUrl, BaseInvoke callbackInvoke) throws Exception {
        Request request = MessageUtil.defaultRequest();
        request.setTimeOut(String.valueOf(REGISTER_API_TIME_OUT));
        request.getRequestMethods().put("RegisterAPI", ConnectManager.LOCAL);
        Message message = MessageUtil.basicMessage(MessageType.Request);
        message.setMessageData(request);
        Channel channel = ConnectManager.getConnectByUrl(kernelUrl);
        if (channel == null) {
            throw new Exception("Kernel not available");
        }
        ResponseContainer responseContainer = RequestContainer.putRequest(message.getMessageID());
        ConnectManager.sendMessage(channel, SerializeUtil.getBuffer(JSONUtils.obj2ByteArray((Object)message)));
        Response response = ResponseMessageProcessor.receiveResponse(responseContainer, REGISTER_API_TIME_OUT);
        for (int tryCount = 0; !response.isSuccess() && tryCount < 3; ++tryCount) {
            Log.info((String)"Failed to send registration message to the core{}second", (Object[])new Object[]{tryCount + 1});
            responseContainer = RequestContainer.putRequest(message.getMessageID());
            ConnectManager.sendMessage(channel, SerializeUtil.getBuffer(JSONUtils.obj2ByteArray((Object)message)));
            response = ResponseMessageProcessor.receiveResponse(responseContainer, REGISTER_API_TIME_OUT);
        }
        if (!response.isSuccess()) {
            throw new Exception("Failed to register with the core\uff01");
        }
        callbackInvoke.callBack(response);
        ResponseMessageProcessor.requestAndInvoke(ModuleE.KE.abbr, "RegisterAPI", JSONUtils.json2map((String)JSONUtils.obj2json((Object)ConnectManager.LOCAL)), "0", "1", callbackInvoke);
        Log.debug((String)("Sync manager success. " + JSONUtils.obj2json(ConnectManager.ROLE_MAP)));
    }

    public static Response requestAndResponse(String role, String cmd, Map params) throws Exception {
        return ResponseMessageProcessor.requestAndResponse(role, cmd, params, 10000L);
    }

    public static Response requestAndResponse(String role, String cmd, Map params, long timeOut) throws Exception {
        if (ModuleE.NC.abbr.equalsIgnoreCase(ConnectManager.LOCAL.getAbbreviation())) {
            String key = role + "_" + cmd;
            InvokeBean invokeBean = INVOKE_BEAN_MAP.get(key);
            if (invokeBean != null) {
                return LocalModuleCall.requestAndResponse(invokeBean, role, cmd, params, timeOut);
            }
            Log.warn((String)"Empty requestAndResponse key: {}", (Object[])new Object[]{key});
        }
        Request request = MessageUtil.newRequest(cmd, params, "0", "0", "0");
        request.setTimeOut(String.valueOf(timeOut));
        ResponseContainer responseContainer = ResponseMessageProcessor.sendRequest(role, request);
        return ResponseMessageProcessor.receiveResponse(responseContainer, timeOut);
    }

    public static String requestAndInvoke(String role, String cmd, Map params, String subscriptionPeriod, String subscriptionEventCounter, BaseInvoke baseInvoke) throws Exception {
        Request request = MessageUtil.newRequest(cmd, params, "0", subscriptionPeriod, subscriptionEventCounter);
        ResponseContainer responseContainer = ResponseMessageProcessor.sendRequest(role, request);
        ConnectManager.INVOKE_MAP.put(responseContainer.getMessageId(), baseInvoke);
        RequestContainer.removeResponseContainer(responseContainer.getMessageId());
        return responseContainer.getMessageId();
    }

    public static String requestAndInvokeWithAck(String role, String cmd, Map params, String subscriptionPeriod, String subscriptionEventCounter, BaseInvoke baseInvoke) throws Exception {
        Request request = MessageUtil.newRequest(cmd, params, "1", subscriptionPeriod, subscriptionEventCounter);
        ResponseContainer responseContainer = ResponseMessageProcessor.sendRequest(role, request);
        ConnectManager.INVOKE_MAP.put(responseContainer.getMessageId(), baseInvoke);
        return ResponseMessageProcessor.receiveResponse(responseContainer, 10000L) != null ? responseContainer.getMessageId() : null;
    }

    public static String requestAndInvoke(String role, Request request, BaseInvoke baseInvoke) throws Exception {
        if (!ConnectManager.isPureDigital(request.getSubscriptionPeriod()) && !ConnectManager.isPureDigital(request.getSubscriptionEventCounter())) {
            throw new Exception("Wrong value: [SubscriptionPeriod][SubscriptionEventCounter]");
        }
        ResponseContainer responseContainer = ResponseMessageProcessor.sendRequest(role, request);
        ConnectManager.INVOKE_MAP.put(responseContainer.getMessageId(), baseInvoke);
        if ("0".equals(request.getRequestAck())) {
            return responseContainer.getMessageId();
        }
        return ResponseMessageProcessor.receiveResponse(responseContainer, 10000L) != null ? responseContainer.getMessageId() : null;
    }

    public static String requestOnly(String role, Request request) throws Exception {
        if (ModuleE.NC.abbr.equalsIgnoreCase(ConnectManager.LOCAL.getAbbreviation())) {
            Map<String, Object> requestMethods = request.getRequestMethods();
            Map.Entry<String, Object> next = requestMethods.entrySet().iterator().next();
            String key = role + "_" + next.getKey();
            InvokeBean invokeBean = INVOKE_BEAN_MAP.get(key);
            if (invokeBean != null) {
                return LocalModuleCall.requestOnly(invokeBean, next.getValue(), role, request);
            }
            Log.warn((String)"Empty requestOnly key: {}", (Object[])new Object[]{key});
        }
        String mappingRole = ROLE_MAPPING.getOrDefault(role, role);
        Message message = MessageUtil.basicMessage(MessageType.RequestOnly);
        message.setMessageData(request);
        Channel channel = ConnectManager.getConnectByRole(mappingRole);
        if (!channel.isWritable()) {
            Log.info((String)"Current request backlog is too high,Waiting for request processing");
            return "0";
        }
        ConnectManager.sendMessage(channel, SerializeUtil.getBuffer(JSONUtils.obj2ByteArray((Object)message)));
        return message.getMessageID();
    }

    private static ResponseContainer sendRequest(String role, Request request) throws Exception {
        String mappingRole = ROLE_MAPPING.getOrDefault(role, role);
        Message message = MessageUtil.basicMessage(MessageType.Request);
        message.setMessageData(request);
        Channel channel = ConnectManager.getConnectByRole(mappingRole);
        ResponseContainer responseContainer = RequestContainer.putRequest(message.getMessageID());
        ConnectManager.sendMessage(channel, SerializeUtil.getBuffer(JSONUtils.obj2ByteArray((Object)message)));
        if (ConnectManager.isPureDigital(request.getSubscriptionPeriod()) || ConnectManager.isPureDigital(request.getSubscriptionEventCounter())) {
            ConnectManager.MSG_ID_KEY_CHANNEL_MAP.put(message.getMessageID(), channel);
        }
        return responseContainer;
    }

    public static void sendUnsubscribe(String messageId) throws Exception {
        if (messageId == null) {
            return;
        }
        Message message = MessageUtil.basicMessage(MessageType.Unsubscribe);
        Unsubscribe unsubscribe = new Unsubscribe();
        unsubscribe.setUnsubscribeMethods(new String[]{messageId});
        message.setMessageData(unsubscribe);
        Channel channel = (Channel)ConnectManager.MSG_ID_KEY_CHANNEL_MAP.get(messageId);
        if (channel != null) {
            ConnectManager.sendMessage(channel, SerializeUtil.getBuffer(JSONUtils.obj2ByteArray((Object)message)));
            Log.debug((String)("Unsubscribe\uff1a" + JSONUtils.obj2json((Object)message)));
            ConnectManager.INVOKE_MAP.remove(messageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Response receiveResponse(ResponseContainer responseContainer, long timeOut) {
        try {
            Response response = responseContainer.getFuture().get(timeOut, TimeUnit.MILLISECONDS);
            return response;
        }
        catch (Exception e) {
            if (timeOut > 0L) {
                Response response = MessageUtil.newFailResponse(responseContainer.getMessageId(), CommonCodeConstanst.REQUEST_TIME_OUT);
                return response;
            }
            Response response = MessageUtil.newSuccessResponse(responseContainer.getMessageId());
            return response;
        }
        finally {
            RequestContainer.removeResponseContainer(responseContainer.getMessageId());
        }
    }

    static {
        ROLE_MAPPING.put(ModuleE.AC.abbr, ModuleE.NC.abbr);
        ROLE_MAPPING.put(ModuleE.BL.abbr, ModuleE.NC.abbr);
        ROLE_MAPPING.put(ModuleE.CS.abbr, ModuleE.NC.abbr);
        ROLE_MAPPING.put(ModuleE.CC.abbr, ModuleE.NC.abbr);
        ROLE_MAPPING.put(ModuleE.CM.abbr, ModuleE.NC.abbr);
        ROLE_MAPPING.put(ModuleE.LG.abbr, ModuleE.NC.abbr);
        ROLE_MAPPING.put(ModuleE.NW.abbr, ModuleE.NC.abbr);
        ROLE_MAPPING.put(ModuleE.PU.abbr, ModuleE.NC.abbr);
        ROLE_MAPPING.put(ModuleE.TX.abbr, ModuleE.NC.abbr);
        ROLE_MAPPING.put(ModuleE.SC.abbr, ModuleE.NC.abbr);
        BaseConstant.NULS_CORES_DOMAINS.addAll(ROLE_MAPPING.keySet());
    }
}

