/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.api.jsonrpc;

import io.nuls.core.core.annotation.Component;
import io.nuls.provider.api.jsonrpc.JsonRpcContext;
import io.nuls.provider.api.jsonrpc.RpcMethodInvoker;
import io.nuls.provider.model.jsonrpc.RpcForm;
import io.nuls.provider.model.jsonrpc.RpcResult;
import io.nuls.provider.model.jsonrpc.RpcResultError;
import io.nuls.provider.utils.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/jsonrpc")
@Component
public class JsonRpcServer {
    @POST
    @Produces(value={"application/json"})
    public Object dispatcher(Object form) {
        if (form == null) {
            return this.responseError("-32700", "", "0");
        }
        if (form instanceof List) {
            return this.dispatcherList((List)form);
        }
        if (form instanceof Map) {
            return this.dispatcher((Map)form);
        }
        return this.responseError("-32700", "the request is not a json-rpc 2.0 request", "0");
    }

    private Object dispatcherList(List<Map<String, Object>> forms) {
        ArrayList<RpcResult> list = new ArrayList<RpcResult>();
        for (Map<String, Object> form : forms) {
            list.add(this.dispatcher(form));
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return list;
    }

    private RpcResult dispatcher(Map<String, Object> form) {
        String method = (String)form.get("method");
        String id = "" + form.get("id");
        String jsonrpc = (String)form.get("jsonrpc");
        if (!"2.0".equals(jsonrpc)) {
            Log.warn("the request is not a json-rpc 2.0 request!");
            return this.responseError("-32600", "the request is not a json-rpc 2.0 request", id);
        }
        RpcMethodInvoker invoker = JsonRpcContext.RPC_METHOD_INVOKER_MAP.get(method);
        if (null == invoker) {
            Log.warn("Can't find the method:{}", method);
            return this.responseError("-32601", "Can't find the method", id);
        }
        RpcResult result = invoker.invoke((List)form.get("params"));
        result.setId(id);
        return result;
    }

    private RpcResult responseError(String code, String message, String id) {
        RpcResult result = new RpcResult();
        RpcResultError error = new RpcResultError();
        error.setCode(code);
        error.setMessage(message);
        result.setError(error);
        result.setId(id);
        return result;
    }

    private static class JsonRpcForm {
        private List<RpcForm> forms;

        private JsonRpcForm() {
        }

        public List<RpcForm> getForms() {
            return this.forms;
        }

        public void setForms(List<RpcForm> forms) {
            this.forms = forms;
        }
    }
}

