/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.api.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.account.AccountService;
import io.nuls.base.api.provider.account.facade.BackupAccountReq;
import io.nuls.base.api.provider.account.facade.CreateAccountReq;
import io.nuls.base.api.provider.account.facade.GetAccountPrivateKeyByAddressReq;
import io.nuls.base.api.provider.account.facade.ImportAccountByKeyStoreReq;
import io.nuls.base.api.provider.account.facade.ImportAccountByPrivateKeyReq;
import io.nuls.base.api.provider.account.facade.SetAccountAliasReq;
import io.nuls.base.api.provider.account.facade.UpdatePasswordReq;
import io.nuls.base.basic.AddressTool;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.model.FormatValidUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.provider.api.config.Config;
import io.nuls.provider.api.config.Context;
import io.nuls.provider.model.ErrorData;
import io.nuls.provider.model.RpcClientResult;
import io.nuls.provider.model.dto.AccountKeyStoreDto;
import io.nuls.provider.model.form.AccountCreateForm;
import io.nuls.provider.model.form.AccountKeyStoreBackup;
import io.nuls.provider.model.form.AccountKeyStoreImportForm;
import io.nuls.provider.model.form.AccountKeyStoreJsonImportForm;
import io.nuls.provider.model.form.AccountPasswordForm;
import io.nuls.provider.model.form.AccountPriKeyPasswordForm;
import io.nuls.provider.model.form.AccountPublicKeyForm;
import io.nuls.provider.model.form.AccountUpdatePasswordForm;
import io.nuls.provider.model.form.EncryptedPriKeySignForm;
import io.nuls.provider.model.form.EncryptedPriKeysSignForm;
import io.nuls.provider.model.form.GetPriKeyForm;
import io.nuls.provider.model.form.MultiSignAccountCreateForm;
import io.nuls.provider.model.form.MultiSignForm;
import io.nuls.provider.model.form.PriKeyForm;
import io.nuls.provider.model.form.PriKeySignForm;
import io.nuls.provider.model.form.ResetPasswordForm;
import io.nuls.provider.model.form.SetAliasForm;
import io.nuls.provider.model.form.ValidateAddressForm;
import io.nuls.provider.rpctools.AccountTools;
import io.nuls.provider.utils.Log;
import io.nuls.provider.utils.ResultUtil;
import io.nuls.v2.error.AccountErrorCode;
import io.nuls.v2.model.annotation.Api;
import io.nuls.v2.model.annotation.ApiOperation;
import io.nuls.v2.model.dto.AccountDto;
import io.nuls.v2.model.dto.AliasDto;
import io.nuls.v2.model.dto.MultiSignAliasDto;
import io.nuls.v2.util.NulsSDKTool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/api/account")
@Component
@Api
public class AccountResource {
    @Autowired
    Config config;
    AccountService accountService = (AccountService)ServiceManager.get(AccountService.class);
    @Autowired
    private AccountTools accountTools;
    private long time;

    @POST
    @Produces(value={"application/json"})
    @ApiOperation(description="Batch Create Accounts", order=101, detailDesc="The created account exists in the local wallet")
    @Parameters(value={@Parameter(parameterName="count", parameterDes="Number of new accounts created,Value[1-10000]"), @Parameter(parameterName="password", parameterDes="Account password")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="list", valueType=List.class, valueElement=String.class, description="Account address")}))
    public RpcClientResult create(AccountCreateForm form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        if (form.getCount() <= 0 || form.getCount() > 10000) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "[count] is invalid"));
        }
        if (!FormatValidUtils.validPassword((String)form.getPassword())) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "[password] is invalid"));
        }
        CreateAccountReq req = new CreateAccountReq(form.getCount(), form.getPassword());
        req.setChainId(this.config.getChainId());
        io.nuls.base.api.provider.Result result = this.accountService.createAccount(req);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            return clientResult.resultMap().map("list", clientResult.getData()).mapToData();
        }
        return clientResult;
    }

    @PUT
    @Path(value="/password/{address}")
    @Produces(value={"application/json"})
    @ApiOperation(description="Change account password", order=102)
    @Parameters(value={@Parameter(parameterName="address", parameterDes="Account address"), @Parameter(parameterName="form", parameterDes="Account Password Information Form", requestType=@TypeDescriptor(value=AccountUpdatePasswordForm.class))})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="Is the modification successful")}))
    public RpcClientResult updatePassword(@PathParam(value="address") String address, AccountUpdatePasswordForm form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        if (!AddressTool.validAddress((int)this.config.getChainId(), (String)address)) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "[address] is invalid"));
        }
        if (!FormatValidUtils.validPassword((String)form.getPassword())) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "[password] is invalid"));
        }
        if (!FormatValidUtils.validPassword((String)form.getNewPassword())) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "[newPassword] is invalid"));
        }
        if (Context.accessLimit && System.currentTimeMillis() - this.time < 3000L) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "Access frequency limit."));
        }
        this.time = System.currentTimeMillis();
        UpdatePasswordReq req = new UpdatePasswordReq(address, form.getPassword(), form.getNewPassword());
        req.setChainId(this.config.getChainId());
        io.nuls.base.api.provider.Result result = this.accountService.updatePassword(req);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            return clientResult.resultMap().map("value", clientResult.getData()).mapToData();
        }
        return clientResult;
    }

    @POST
    @Path(value="/prikey/{address}")
    @Produces(value={"application/json"})
    @ApiOperation(description="Export account private key", order=103, detailDesc="Only the private key of an existing account in the local wallet can be exported")
    @Parameters(value={@Parameter(parameterName="address", parameterDes="Account address"), @Parameter(parameterName="form", parameterDes="Account Password Information Form", requestType=@TypeDescriptor(value=AccountPasswordForm.class))})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Private key")}))
    public RpcClientResult getPriKey(@PathParam(value="address") String address, AccountPasswordForm form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        if (address == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "address is empty"));
        }
        if (Context.accessLimit && System.currentTimeMillis() - this.time < 3000L) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "Access frequency limit."));
        }
        this.time = System.currentTimeMillis();
        GetAccountPrivateKeyByAddressReq req = new GetAccountPrivateKeyByAddressReq(form.getPassword(), address);
        req.setChainId(this.config.getChainId());
        io.nuls.base.api.provider.Result result = this.accountService.getAccountPrivateKey(req);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            return clientResult.resultMap().map("value", clientResult.getData()).mapToData();
        }
        return clientResult;
    }

    @POST
    @Path(value="/import/pri")
    @Produces(value={"application/json"})
    @ApiOperation(description="Import account based on private key", order=104, detailDesc="When importing a private key, you need to enter a password to encrypt the plaintext private key")
    @Parameters(value={@Parameter(parameterName="form", parameterDes="Import account form based on private key", requestType=@TypeDescriptor(value=AccountPriKeyPasswordForm.class))})
    @ResponseData(name="Return value", description="Return account address", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Account address")}))
    public RpcClientResult importPriKey(AccountPriKeyPasswordForm form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        if (!FormatValidUtils.validPassword((String)form.getPassword())) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "[password] is invalid"));
        }
        ImportAccountByPrivateKeyReq req = new ImportAccountByPrivateKeyReq(form.getPassword(), form.getPriKey(), form.getOverwrite().booleanValue());
        req.setChainId(this.config.getChainId());
        io.nuls.base.api.provider.Result result = this.accountService.importAccountByPrivateKey(req);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            return clientResult.resultMap().map("value", clientResult.getData()).mapToData();
        }
        return clientResult;
    }

    @POST
    @Path(value="/import/keystore")
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    @ApiOperation(description="according tokeyStoreImport account", order=105)
    @Parameters(value={@Parameter(parameterName="Import account based on private key", parameterDes="Import account form based on private key", requestType=@TypeDescriptor(value=InputStream.class))})
    @ResponseData(name="Return value", description="Return account address", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Account address")}))
    public RpcClientResult importAccountByKeystoreFile(@FormDataParam(value="keystore") InputStream in, @FormDataParam(value="password") String password) {
        if (in == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "inputStream is empty"));
        }
        io.nuls.base.api.provider.Result<AccountKeyStoreDto> dtoResult = this.getAccountKeyStoreDto(in);
        if (dtoResult.isFailed()) {
            return RpcClientResult.getFailed(new ErrorData(dtoResult.getStatus(), dtoResult.getMessage()));
        }
        AccountKeyStoreDto dto = (AccountKeyStoreDto)dtoResult.getData();
        try {
            ImportAccountByKeyStoreReq req = new ImportAccountByKeyStoreReq(password, HexUtil.encode((byte[])JSONUtils.obj2json((Object)dto).getBytes()), true);
            req.setChainId(this.config.getChainId());
            io.nuls.base.api.provider.Result result = this.accountService.importAccountByKeyStore(req);
            RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
            if (clientResult.isSuccess()) {
                return clientResult.resultMap().map("value", clientResult.getData()).mapToData();
            }
            return clientResult;
        }
        catch (JsonProcessingException e) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.DATA_ERROR.getCode(), e.getMessage()));
        }
    }

    @POST
    @Path(value="/import/keystore/path")
    @Produces(value={"application/json"})
    @ApiOperation(description="according tokeystoreFile path import account", order=106)
    @Parameters(value={@Parameter(parameterName="form", parameterDes="according tokeystoreFile path import account form", requestType=@TypeDescriptor(value=AccountKeyStoreImportForm.class))})
    @ResponseData(name="Return value", description="Return account address", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Account address")}))
    public RpcClientResult importAccountByKeystoreFilePath(AccountKeyStoreImportForm form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        String keystore = this.accountService.getAccountKeystoreDto(form.getPath());
        ImportAccountByKeyStoreReq req = new ImportAccountByKeyStoreReq(form.getPassword(), HexUtil.encode((byte[])keystore.getBytes()), true);
        req.setChainId(this.config.getChainId());
        io.nuls.base.api.provider.Result result = this.accountService.importAccountByKeyStore(req);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            return clientResult.resultMap().map("value", clientResult.getData()).mapToData();
        }
        return clientResult;
    }

    @POST
    @Path(value="/import/keystore/json")
    @Produces(value={"application/json"})
    @ApiOperation(description="according tokeystoreString import account", order=107)
    @Parameters(value={@Parameter(parameterName="form", parameterDes="according tokeystoreString import account form", requestType=@TypeDescriptor(value=AccountKeyStoreJsonImportForm.class))})
    @ResponseData(name="Return value", description="Return account address", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Account address")}))
    public RpcClientResult importAccountByKeystoreJson(AccountKeyStoreJsonImportForm form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        String keystore = null;
        try {
            keystore = JSONUtils.obj2json((Object)form.getKeystore());
        }
        catch (JsonProcessingException e) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "keystore is invalid"));
        }
        ImportAccountByKeyStoreReq req = new ImportAccountByKeyStoreReq(form.getPassword(), HexUtil.encode((byte[])keystore.getBytes()), true);
        req.setChainId(this.config.getChainId());
        io.nuls.base.api.provider.Result result = this.accountService.importAccountByKeyStore(req);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            return clientResult.resultMap().map("value", clientResult.getData()).mapToData();
        }
        return clientResult;
    }

    @POST
    @Path(value="/export/{address}")
    @Produces(value={"application/json"})
    @ApiOperation(description="Account backup, exportAccountKeyStoreFile to specified directory", order=108)
    @Parameters(value={@Parameter(parameterName="address", parameterDes="Account address", requestType=@TypeDescriptor(value=String.class)), @Parameter(parameterName="form", parameterDes="keystoneExport Information Form", requestType=@TypeDescriptor(value=AccountKeyStoreBackup.class))})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="path", description="Exported file path")}))
    public RpcClientResult exportAccountKeyStore(@PathParam(value="address") String address, AccountKeyStoreBackup form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        if (address == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "address is empty"));
        }
        if (System.currentTimeMillis() - this.time < 3000L) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "Access frequency limit."));
        }
        this.time = System.currentTimeMillis();
        BackupAccountReq req = new BackupAccountReq(form.getPassword(), address, form.getPath());
        req.setChainId(this.config.getChainId());
        io.nuls.base.api.provider.Result result = this.accountService.backupAccount(req);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            return clientResult.resultMap().map("path", clientResult.getData()).mapToData();
        }
        return clientResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private io.nuls.base.api.provider.Result<AccountKeyStoreDto> getAccountKeyStoreDto(InputStream in) {
        StringBuilder ks = new StringBuilder();
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String str;
            inputStreamReader = new InputStreamReader(in);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((str = bufferedReader.readLine()) != null) {
                if (str.isEmpty()) continue;
                ks.append(str);
            }
            AccountKeyStoreDto accountKeyStoreDto = (AccountKeyStoreDto)JSONUtils.json2pojo((String)ks.toString(), AccountKeyStoreDto.class);
            io.nuls.base.api.provider.Result result = new io.nuls.base.api.provider.Result((Object)accountKeyStoreDto);
            return result;
        }
        catch (Exception e) {
            io.nuls.base.api.provider.Result result = io.nuls.base.api.provider.Result.fail((String)CommonCodeConstanst.FILE_OPERATION_FAILD.getCode(), (String)"key store file error");
            return result;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    Log.error(e);
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException e) {
                    Log.error(e);
                }
            }
        }
    }

    @POST
    @Path(value="/alias")
    @Produces(value={"application/json"})
    @ApiOperation(description="Account setting alias", order=109, detailDesc="The alias format is1-20A combination of lowercase letters and numbers, setting an alias will destroy it1individualNULS")
    @Parameters(value={@Parameter(parameterName="form", parameterDes="Account alias setting form", requestType=@TypeDescriptor(value=SetAliasForm.class))})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Setting up alias transactionshash")}))
    public RpcClientResult setAlias(SetAliasForm form) {
        if (!AddressTool.validAddress((int)this.config.getChainId(), (String)form.getAddress())) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "address is invalid"));
        }
        if (!FormatValidUtils.validAlias((String)form.getAlias())) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "alias is invalid"));
        }
        if (StringUtils.isBlank((String)form.getPassword())) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "password is invalid"));
        }
        SetAccountAliasReq aliasReq = new SetAccountAliasReq(form.getPassword(), form.getAddress(), form.getAlias());
        io.nuls.base.api.provider.Result result = this.accountService.setAccountAlias(aliasReq);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            return clientResult.resultMap().map("value", clientResult.getData()).mapToData();
        }
        return clientResult;
    }

    @POST
    @Path(value="/address/validate")
    @Produces(value={"application/json"})
    @ApiOperation(description="Verify if the address format is correct", order=110, detailDesc="Verify if the address format is correct")
    @Parameters(value={@Parameter(parameterName="form", parameterDes="Account alias setting form", requestType=@TypeDescriptor(value=ValidateAddressForm.class))})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="true")}))
    public RpcClientResult validateAddress(ValidateAddressForm form) {
        boolean b = AddressTool.validAddress((int)form.getChainId(), (String)form.getAddress());
        if (b) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("value", true);
            return RpcClientResult.getSuccess(map);
        }
        return RpcClientResult.getFailed(new ErrorData(AccountErrorCode.ADDRESS_ERROR.getCode(), "address is wrong"));
    }

    @POST
    @Path(value="/address/publickey")
    @Produces(value={"application/json"})
    @ApiOperation(description="Generate account address based on account public key", order=111, detailDesc="Generate account address based on account public key")
    @Parameters(value={@Parameter(parameterName="form", parameterDes="Generate account address based on account public key", requestType=@TypeDescriptor(value=AccountPublicKeyForm.class))})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="address", description="Account address")}))
    public RpcClientResult getAddressByPublicKey(AccountPublicKeyForm form) {
        try {
            byte[] address = AddressTool.getAddress((byte[])HexUtil.decode((String)form.getPublicKey()), (int)form.getChainId());
            return RpcClientResult.getSuccess(Map.of("address", AddressTool.getStringAddressByBytes((byte[])address)));
        }
        catch (Exception e) {
            Log.error(e);
            return RpcClientResult.getFailed(new ErrorData(AccountErrorCode.ADDRESS_ERROR.getCode(), "address is wrong"));
        }
    }

    @POST
    @Path(value="/offline")
    @Produces(value={"application/json"})
    @ApiOperation(description="off-line - Batch Create Accounts", order=151, detailDesc="The created account will not be saved to the wallet,The interface directly returns the account'skeystoreinformation")
    @Parameters(value={@Parameter(parameterName="form", parameterDes="Offline batch creation of account forms", requestType=@TypeDescriptor(value=AccountCreateForm.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="list", valueType=List.class, valueElement=AccountDto.class, description="accountkeystorelist")}))
    public RpcClientResult createOffline(AccountCreateForm form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        Result result = StringUtils.isBlank((String)form.getPrefix()) ? NulsSDKTool.createOffLineAccount((int)form.getCount(), (String)form.getPassword()) : NulsSDKTool.createOffLineAccount((int)form.getChainId(), (int)form.getCount(), (String)form.getPrefix(), (String)form.getPassword());
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/priKey/offline")
    @Produces(value={"application/json"})
    @ApiOperation(description="Offline acquisition of account plaintext private key", order=152)
    @Parameters(value={@Parameter(parameterName="form", parameterDes="Offline access to account plaintext private key form", requestType=@TypeDescriptor(value=GetPriKeyForm.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Clear text private key")}))
    public RpcClientResult getPriKeyOffline(GetPriKeyForm form) {
        Result result = NulsSDKTool.getPriKeyOffline((String)form.getAddress(), (String)form.getEncryptedPriKey(), (String)form.getPassword());
        return ResultUtil.getRpcClientResult(result);
    }

    @PUT
    @Path(value="/password/offline/")
    @Produces(value={"application/json"})
    @ApiOperation(description="Offline account password modification", order=153)
    @Parameters(value={@Parameter(parameterName="form", parameterDes="Offline account password modification form", requestType=@TypeDescriptor(value=ResetPasswordForm.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Encryption private key after resetting password")}))
    public RpcClientResult resetPasswordOffline(ResetPasswordForm form) {
        Result result = NulsSDKTool.resetPasswordOffline((String)form.getAddress(), (String)form.getEncryptedPriKey(), (String)form.getOldPassword(), (String)form.getNewPassword());
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/multi/sign")
    @Produces(value={"application/json"})
    @ApiOperation(description="Multiple Account Summary Signature", order=154, detailDesc="For multi account transfer transactions used for offline assembly of signatures, when calling the interface, parameters can be passed to the address and private key, or to the address and encrypted private key and encrypted password")
    @Parameters(value={@Parameter(parameterName="form", parameterDes="Multiple Account Summary Signature Form", requestType=@TypeDescriptor(value=MultiSignForm.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Signed transaction16Hexadecimal Strings")}))
    public RpcClientResult multiSign(MultiSignForm form) {
        Result result = NulsSDKTool.sign(form.getDtoList(), (String)form.getTxHex());
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/priKey/sign")
    @Produces(value={"application/json"})
    @ApiOperation(description="Clear text private key digest signature", order=155)
    @Parameters(value={@Parameter(parameterName="form", parameterDes="Clear text private key abstract signature form", requestType=@TypeDescriptor(value=PriKeySignForm.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Signed transaction16Hexadecimal Strings")}))
    public RpcClientResult priKeySign(PriKeySignForm form) {
        Result result = NulsSDKTool.sign((String)form.getTxHex(), (String)form.getAddress(), (String)form.getPriKey());
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/encryptedPriKey/sign")
    @Produces(value={"application/json"})
    @ApiOperation(description="Cryptography private key digest signature", order=156)
    @Parameters(value={@Parameter(parameterName="form", parameterDes="Cryptography private key digest signature form", requestType=@TypeDescriptor(value=EncryptedPriKeySignForm.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Signed transaction16Hexadecimal Strings")}))
    public RpcClientResult encryptedPriKeySign(EncryptedPriKeySignForm form) {
        Result result = NulsSDKTool.sign((String)form.getTxHex(), (String)form.getAddress(), (String)form.getEncryptedPriKey(), (String)form.getPassword());
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/encryptedPriKeys/sign")
    @Produces(value={"application/json"})
    @ApiOperation(description="Multiple account ciphertext private key digest signature", order=156)
    @Parameters(value={@Parameter(parameterName="form", parameterDes="Cryptography private key digest signature form", requestType=@TypeDescriptor(value=EncryptedPriKeySignForm.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Signed transaction16Hexadecimal Strings")}))
    public RpcClientResult encryptedPriKeysSign(EncryptedPriKeysSignForm form) {
        Result result = NulsSDKTool.sign((int)form.getChainId(), (String)form.getPrefix(), form.getSignDtoList(), (String)form.getTxHex());
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/multiSign/create")
    @Produces(value={"application/json"})
    @ApiOperation(description="Create a multi signature account", order=157, detailDesc="Create multiple signed accounts based on the public keys of multiple accounts,minSignsThe minimum number of signatures required to create transactions for multi signature accounts")
    @Parameters(value={@Parameter(parameterName="form", parameterDes="Create a multi signature account form", requestType=@TypeDescriptor(value=MultiSignAccountCreateForm.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="The address of the account")}))
    public RpcClientResult createMultiSignAccount(MultiSignAccountCreateForm form) {
        if (form.getPubKeys() == null || form.getPubKeys().isEmpty()) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "pubKeys is empty"));
        }
        if (form.getMinSigns() < 1 || form.getMinSigns() > form.getPubKeys().size()) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "[minSigns] is invalid"));
        }
        Result result = NulsSDKTool.createMultiSignAccount(form.getPubKeys(), (int)form.getMinSigns());
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/aliasTx/create")
    @Produces(value={"application/json"})
    @ApiOperation(description="Offline creation and setting of alias transactions", order=158, detailDesc="Create multiple signed accounts based on the public keys of multiple accounts,minSignsThe minimum number of signatures required to create transactions for multi signature accounts")
    @Parameters(value={@Parameter(parameterName="dto", parameterDes="Create a multi signature account form", requestType=@TypeDescriptor(value=AliasDto.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization16Hexadecimal Strings")}))
    public RpcClientResult createAliasTxOffLine(AliasDto dto) {
        Result result = NulsSDKTool.createAliasTxOffline((AliasDto)dto);
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/multiSign/aliasTx/create")
    @Produces(value={"application/json"})
    @ApiOperation(description="Offline creation and setting of alias transactions for multiple signed accounts", order=159)
    @Parameters(value={@Parameter(parameterName="dto", parameterDes="Create an alias transaction form", requestType=@TypeDescriptor(value=MultiSignAliasDto.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization16Hexadecimal Strings")}))
    public RpcClientResult createMultiSignAliasTxOffLine(MultiSignAliasDto dto) {
        Result result = NulsSDKTool.createMultiSignAliasTxOffline((MultiSignAliasDto)dto);
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/address/priKey")
    @Produces(value={"application/json"})
    @ApiOperation(description="Obtain account address format based on private key", order=160)
    @Parameters(value={@Parameter(parameterName="form", parameterDes="Private Key Form", requestType=@TypeDescriptor(value=PriKeyForm.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Account address")}))
    public RpcClientResult getAddressByPriKey(PriKeyForm form) {
        Result result = NulsSDKTool.getAddressByPriKey((String)form.getPriKey());
        return ResultUtil.getRpcClientResult(result);
    }
}

