/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.api.resources;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.block.BlockService;
import io.nuls.base.api.provider.block.facade.BlockHeaderData;
import io.nuls.base.api.provider.block.facade.GetBlockHeaderByHeightReq;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.provider.api.config.Config;
import io.nuls.provider.model.ErrorData;
import io.nuls.provider.model.RpcClientResult;
import io.nuls.provider.model.dto.TransactionDto;
import io.nuls.provider.rpctools.TransactionTools;
import io.nuls.provider.utils.ResultUtil;
import io.nuls.v2.model.annotation.Api;
import io.nuls.v2.model.annotation.ApiOperation;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/api/tx")
@Component
@Api
public class TransactionResource {
    @Autowired
    Config config;
    @Autowired
    TransactionTools transactionTools;
    BlockService blockService = (BlockService)ServiceManager.get(BlockService.class);

    @GET
    @Path(value="/{hash}")
    @Produces(value={"application/json"})
    @ApiOperation(description="according tohashObtain transactions", order=301)
    @Parameters(value={@Parameter(parameterName="hash", requestType=@TypeDescriptor(value=String.class), parameterDes="transactionhash")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=TransactionDto.class))
    public RpcClientResult getTx(@PathParam(value="hash") String hash) {
        TransactionDto txDto;
        if (hash == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "hash is empty"));
        }
        Result<TransactionDto> result = this.transactionTools.getTx(this.config.getChainId(), hash);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess() && (txDto = (TransactionDto)clientResult.getData()).getBlockHeight() >= 0L) {
            GetBlockHeaderByHeightReq req = new GetBlockHeaderByHeightReq(Long.valueOf(txDto.getBlockHeight()));
            req.setChainId(this.config.getChainId());
            Result blockResult = this.blockService.getBlockHeaderByHeight(req);
            if (blockResult.isSuccess()) {
                txDto.setBlockHash(((BlockHeaderData)blockResult.getData()).getHash());
            }
        }
        return clientResult;
    }
}

