/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.model.dto.block;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.BlockExtendsData;
import io.nuls.base.data.BlockHeader;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.util.NulsDateUtils;
import io.nuls.provider.api.config.Context;
import java.util.List;

@ApiModel(description="blockHeader Block header information, Only return the corresponding partial data")
public class BlockHeaderDto {
    @ApiModelProperty(description="Blockedhashvalue")
    private String hash;
    @ApiModelProperty(description="Previous block'shashvalue")
    private String preHash;
    @ApiModelProperty(description="Merkelhash")
    private String merkleHash;
    @ApiModelProperty(description="Block generation time")
    private String time;
    @ApiModelProperty(description="Block generation timestamp")
    private long timestamp;
    @ApiModelProperty(description="block height")
    private long height;
    @ApiModelProperty(description="Number of block packaging transactions")
    private int txCount;
    @ApiModelProperty(description="autographHex.encode(byte[])")
    private String blockSignature;
    @ApiModelProperty(description="size")
    private int size;
    @ApiModelProperty(description="Packaging address")
    private String packingAddress;
    @ApiModelProperty(description="Consensus round")
    private long roundIndex;
    @ApiModelProperty(description="Number of members participating in consensus")
    private int consensusMemberCount;
    @ApiModelProperty(description="Current consensus round start time")
    private String roundStartTime;
    @ApiModelProperty(description="Current consensus round start timestamp")
    private long roundStartTimestamp;
    @ApiModelProperty(description="The ranking of the blocks packaged in the current round")
    private int packingIndexOfRound;
    @ApiModelProperty(description="The current effective version of the main network")
    private short mainVersion;
    @ApiModelProperty(description="The version of the block can be understood as the version of the local wallet")
    private short blockVersion;
    @ApiModelProperty(description="Smart Contract World State Root")
    private String stateRoot;
    @ApiModelProperty(description="Block packaged transactionshashaggregate", type=@TypeDescriptor(value=List.class, collectionElement=String.class))
    private List<String> txHashList;

    public BlockHeaderDto() {
    }

    public BlockHeaderDto(BlockHeader header) {
        BlockExtendsData blockExtendsData = header.getExtendsData();
        this.setHash(header.getHash().toString());
        this.setHeight(header.getHeight());
        this.setSize(header.size());
        this.setTime(NulsDateUtils.timeStamp2DateStr((long)(header.getTime() * 1000L)));
        this.setTimestamp(header.getTime());
        this.setTxCount(header.getTxCount());
        this.setMerkleHash(header.getMerkleHash().toString());
        this.setBlockSignature(header.getBlockSignature().getSignData().toString());
        this.setPreHash(header.getPreHash().toString());
        this.setPackingAddress(AddressTool.getStringAddressByBytes((byte[])header.getPackingAddress(Context.getChainId().intValue())));
        this.setConsensusMemberCount(blockExtendsData.getConsensusMemberCount());
        this.setMainVersion(blockExtendsData.getMainVersion());
        this.setBlockVersion(blockExtendsData.getBlockVersion());
        this.setPackingIndexOfRound(blockExtendsData.getPackingIndexOfRound());
        this.setRoundIndex(blockExtendsData.getRoundIndex());
        this.setRoundStartTimestamp(blockExtendsData.getRoundStartTime());
        this.setRoundStartTime(NulsDateUtils.timeStamp2DateStr((long)(blockExtendsData.getRoundStartTime() * 1000L)));
        this.setStateRoot(RPCUtil.encode((byte[])blockExtendsData.getStateRoot()));
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getPreHash() {
        return this.preHash;
    }

    public void setPreHash(String preHash) {
        this.preHash = preHash;
    }

    public String getMerkleHash() {
        return this.merkleHash;
    }

    public void setMerkleHash(String merkleHash) {
        this.merkleHash = merkleHash;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    public int getTxCount() {
        return this.txCount;
    }

    public void setTxCount(int txCount) {
        this.txCount = txCount;
    }

    public String getBlockSignature() {
        return this.blockSignature;
    }

    public void setBlockSignature(String blockSignature) {
        this.blockSignature = blockSignature;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getPackingAddress() {
        return this.packingAddress;
    }

    public void setPackingAddress(String packingAddress) {
        this.packingAddress = packingAddress;
    }

    public long getRoundIndex() {
        return this.roundIndex;
    }

    public void setRoundIndex(long roundIndex) {
        this.roundIndex = roundIndex;
    }

    public int getConsensusMemberCount() {
        return this.consensusMemberCount;
    }

    public void setConsensusMemberCount(int consensusMemberCount) {
        this.consensusMemberCount = consensusMemberCount;
    }

    public String getRoundStartTime() {
        return this.roundStartTime;
    }

    public void setRoundStartTime(String roundStartTime) {
        this.roundStartTime = roundStartTime;
    }

    public int getPackingIndexOfRound() {
        return this.packingIndexOfRound;
    }

    public void setPackingIndexOfRound(int packingIndexOfRound) {
        this.packingIndexOfRound = packingIndexOfRound;
    }

    public short getMainVersion() {
        return this.mainVersion;
    }

    public void setMainVersion(short mainVersion) {
        this.mainVersion = mainVersion;
    }

    public short getBlockVersion() {
        return this.blockVersion;
    }

    public void setBlockVersion(short blockVersion) {
        this.blockVersion = blockVersion;
    }

    public String getStateRoot() {
        return this.stateRoot;
    }

    public void setStateRoot(String stateRoot) {
        this.stateRoot = stateRoot;
    }

    public List<String> getTxHashList() {
        return this.txHashList;
    }

    public void setTxHashList(List<String> txHashList) {
        this.txHashList = txHashList;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getRoundStartTimestamp() {
        return this.roundStartTimestamp;
    }

    public void setRoundStartTimestamp(long roundStartTimestamp) {
        this.roundStartTimestamp = roundStartTimestamp;
    }
}

