/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.rpctools;

import io.nuls.base.api.provider.Result;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.log.Log;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.parse.MapUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.provider.api.config.Context;
import io.nuls.provider.model.dto.ContractTokenInfoDto;
import io.nuls.provider.rpctools.CallRpc;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class ContractTools
implements CallRpc {
    public Result<ContractTokenInfoDto> getTokenBalance(int chainId, String contractAddress, String address) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("contractAddress", contractAddress);
        params.put("address", address);
        try {
            return this.callRpc(ModuleE.SC.abbr, "sc_token_balance", params, res -> {
                if (res == null) {
                    return new Result();
                }
                return new Result(MapUtils.mapToBean((Map)res, (Object)new ContractTokenInfoDto()));
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<Map> getContractInfo(int chainId, String contractAddress) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("contractAddress", contractAddress);
        try {
            return this.callRpc(ModuleE.SC.abbr, "sc_contract_info", params, res -> {
                if (res == null) {
                    return new Result();
                }
                return new Result(res);
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<Map> getContractResult(int chainId, String hash) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("hash", hash);
        try {
            return this.callRpc(ModuleE.SC.abbr, "sc_contract_result", params, res -> {
                if (res == null) {
                    return new Result();
                }
                return new Result(res);
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<Map> getContractTx(int chainId, String hash) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("hash", hash);
        try {
            return this.callRpc(ModuleE.SC.abbr, "sc_contract_tx", params, res -> {
                if (res == null) {
                    return new Result();
                }
                return new Result(res);
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<Map> getContractResultList(int chainId, List<String> hashList) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("hashList", hashList);
        try {
            return this.callRpc(ModuleE.SC.abbr, "sc_contract_result_list", params, res -> {
                if (res == null) {
                    return new Result();
                }
                return new Result(res);
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<Map> getContractConstructor(int chainId, String contractCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chainId", chainId);
        params.put("contractCode", contractCode);
        try {
            return this.callRpc(ModuleE.SC.abbr, "sc_constructor", params, res -> {
                if (res == null) {
                    return new Result();
                }
                return new Result(res);
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<Map> validateContractCreate(int chainId, Object sender, Object gasLimit, Object price, Object contractCode, Object args) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chainId", chainId);
        params.put("sender", sender);
        params.put("gasLimit", gasLimit);
        params.put("price", price);
        params.put("contractCode", contractCode);
        params.put("args", args);
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        try {
            return this.callRpc(ModuleE.SC.abbr, "sc_validate_create", params, res -> {
                map.put("success", true);
                return new Result((Object)map);
            });
        }
        catch (NulsRuntimeException e) {
            map.put("success", false);
            map.put("code", e.getCode());
            map.put("msg", e.getMessage());
            return new Result(map);
        }
    }

    public Result<Map> contractCall(int chainId, Object sender, Object password, Object value, Object gasLimit, Object price, Object contractAddress, Object methodName, Object methodDesc, Object args, Object remark, Object multyAssetValues) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chainId", chainId);
        params.put("sender", sender);
        params.put("password", password);
        params.put("value", value);
        params.put("gasLimit", gasLimit);
        params.put("price", price);
        params.put("contractAddress", contractAddress);
        params.put("methodName", methodName);
        params.put("methodDesc", methodDesc);
        params.put("args", args);
        params.put("remark", remark);
        params.put("multyAssetValues", multyAssetValues);
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        try {
            return this.callRpc(ModuleE.SC.abbr, "sc_call", params, res -> new Result(res));
        }
        catch (NulsRuntimeException e) {
            map.put("success", false);
            map.put("code", e.getCode());
            map.put("msg", e.getMessage());
            return new Result(map);
        }
    }

    public Result<Map> validateContractCall(int chainId, Object sender, Object value, Object gasLimit, Object price, Object contractAddress, Object methodName, Object methodDesc, Object args, Object multyAssetValues) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chainId", chainId);
        params.put("sender", sender);
        params.put("value", value);
        params.put("gasLimit", gasLimit);
        params.put("price", price);
        params.put("contractAddress", contractAddress);
        params.put("methodName", methodName);
        params.put("methodDesc", methodDesc);
        params.put("args", args);
        params.put("multyAssetValues", multyAssetValues);
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        try {
            return this.callRpc(ModuleE.SC.abbr, "sc_validate_call", params, res -> {
                map.put("success", true);
                return new Result((Object)map);
            });
        }
        catch (NulsRuntimeException e) {
            map.put("success", false);
            map.put("code", e.getCode());
            map.put("msg", e.getMessage());
            return new Result(map);
        }
    }

    public Result<Map> validateContractDelete(int chainId, Object sender, Object contractAddress) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chainId", chainId);
        params.put("sender", sender);
        params.put("contractAddress", contractAddress);
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        try {
            return this.callRpc(ModuleE.SC.abbr, "sc_validate_delete", params, res -> {
                map.put("success", true);
                return new Result((Object)map);
            });
        }
        catch (NulsRuntimeException e) {
            map.put("success", false);
            map.put("code", e.getCode());
            map.put("msg", e.getMessage());
            return new Result(map);
        }
    }

    public Result<Map> imputedContractCreateGas(int chainId, Object sender, Object contractCode, Object args) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chainId", chainId);
        params.put("sender", sender);
        params.put("contractCode", contractCode);
        params.put("args", args);
        try {
            return this.callRpc(ModuleE.SC.abbr, "sc_imputed_create_gas", params, res -> {
                if (res == null) {
                    return null;
                }
                return new Result(res);
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<Map> imputedContractCallGas(int chainId, Object sender, Object value, Object contractAddress, Object methodName, Object methodDesc, Object args, Object multyAssetValues) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chainId", chainId);
        params.put("sender", sender);
        params.put("value", value);
        params.put("contractAddress", contractAddress);
        params.put("methodName", methodName);
        params.put("methodDesc", methodDesc);
        params.put("args", args);
        params.put("multyAssetValues", multyAssetValues);
        try {
            return this.callRpc(ModuleE.SC.abbr, "sc_imputed_call_gas", params, res -> {
                if (res == null) {
                    return null;
                }
                return new Result(res);
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<List<String>> multicall(int chainId, Object height, List contracts, List methods, List params) {
        try {
            Result<Map> result = this.invokeView(chainId, height, Context.multicall, "aggregateStrict", null, new Object[]{contracts.toArray(), methods.toArray(), params.toArray(), false});
            Map dataMap = (Map)result.getData();
            if (dataMap == null) {
                return new Result(Collections.emptyList());
            }
            List list = (List)JSONUtils.json2pojo((String)dataMap.get("result").toString(), List.class);
            return new Result((Object)list);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return new Result(Collections.emptyList());
        }
    }

    public Result<Map> invokeView(int chainId, Object height, Object contractAddress, Object methodName, Object methodDesc, Object args) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chainId", chainId);
        params.put("height", height);
        params.put("contractAddress", contractAddress);
        params.put("methodName", methodName);
        params.put("methodDesc", methodDesc);
        params.put("args", args);
        try {
            return this.callRpc(ModuleE.SC.abbr, "sc_invoke_view_by_height", params, res -> {
                if (res == null) {
                    return null;
                }
                return new Result(res);
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<Map> codeHash(int chainId, Object contractAddress) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chainId", chainId);
        params.put("contractAddress", contractAddress);
        try {
            return this.callRpc(ModuleE.SC.abbr, "sc_code_hash", params, res -> {
                if (res == null) {
                    return null;
                }
                return new Result(res);
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<Map> contractCode(int chainId, Object contractAddress) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chainId", chainId);
        params.put("contractAddress", contractAddress);
        try {
            return this.callRpc(ModuleE.SC.abbr, "sc_contract_code", params, res -> {
                if (res == null) {
                    return null;
                }
                return new Result(res);
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<Map> computeAddress(int chainId, Object sender, Object codeHash, Object salt) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chainId", chainId);
        params.put("sender", sender);
        params.put("codeHash", codeHash);
        params.put("salt", salt);
        try {
            return this.callRpc(ModuleE.SC.abbr, "sc_compute_address", params, res -> {
                if (res == null) {
                    return null;
                }
                return new Result(res);
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result commonRequest(String cmd, Map params) {
        try {
            return this.callRpc(ModuleE.SC.abbr, cmd, params, res -> {
                if (res == null) {
                    return new Result();
                }
                return new Result(res);
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }
}

