/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.rpctools;

import io.nuls.base.api.provider.Result;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.provider.api.cache.LedgerAssetCache;
import io.nuls.provider.api.model.AssetInfo;
import io.nuls.provider.rpctools.CallRpc;
import io.nuls.provider.rpctools.ContractTools;
import io.nuls.provider.rpctools.vo.AccountBalance;
import io.nuls.provider.rpctools.vo.AccountBalanceWithDecimals;
import io.nuls.provider.utils.Log;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Component
public class LegderTools
implements CallRpc {
    @Autowired
    private ContractTools contractTools;
    @Autowired
    private LedgerAssetCache ledgerAssetCache;

    public Result<AccountBalance> getBalanceAndNonce(int chainId, int assetChainId, int assetId, String address) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("assetChainId", assetChainId);
        params.put("address", address);
        params.put("assetId", assetId);
        try {
            return this.callRpc(ModuleE.LG.abbr, "getBalanceNonce", params, map -> {
                if (map == null) {
                    return null;
                }
                AccountBalance balanceInfo = new AccountBalance();
                balanceInfo.setBalance(map.get("available").toString());
                balanceInfo.setTimeLock(map.get("timeHeightLocked").toString());
                balanceInfo.setConsensusLock(map.get("permanentLocked").toString());
                balanceInfo.setFreeze(map.get("freeze").toString());
                balanceInfo.setNonce((String)map.get("nonce"));
                balanceInfo.setTotalBalance(new BigInteger(balanceInfo.getBalance()).add(new BigInteger(balanceInfo.getConsensusLock())).add(new BigInteger(balanceInfo.getTimeLock())).toString());
                balanceInfo.setNonceType((Integer)map.get("nonceType"));
                return new Result((Object)balanceInfo);
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<Map<String, AccountBalance>> getBalanceAndNonceMap(int chainId, List<String> assetKeyList, String address, List<Boolean> isConfirmedList) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("assetKeyList", assetKeyList);
        params.put("address", address);
        params.put("isConfirmedList", isConfirmedList);
        try {
            return this.callRpc(ModuleE.LG.abbr, "getBalanceNonceList", params, _map -> {
                if (_map == null) {
                    return null;
                }
                LinkedHashMap<String, AccountBalance> resultMap = new LinkedHashMap<String, AccountBalance>();
                Map dataMap = (Map)_map.get("list");
                for (int i = 0; i < assetKeyList.size(); ++i) {
                    String assetKey = (String)assetKeyList.get(i);
                    Map map = (Map)dataMap.get(assetKey);
                    if (map == null) continue;
                    String[] split = assetKey.split("-");
                    int assetChainId = Integer.parseInt(split[0]);
                    int assetId = Integer.parseInt(split[1]);
                    AccountBalance balanceInfo = new AccountBalance();
                    balanceInfo.setAssetChainId(assetChainId);
                    balanceInfo.setAssetId(assetId);
                    balanceInfo.setBalance(map.get("available").toString());
                    balanceInfo.setTimeLock(map.get("timeHeightLocked").toString());
                    balanceInfo.setConsensusLock(map.get("permanentLocked").toString());
                    balanceInfo.setFreeze(map.get("freeze").toString());
                    balanceInfo.setNonce((String)map.get("nonce"));
                    balanceInfo.setTotalBalance(new BigInteger(balanceInfo.getBalance()).add(new BigInteger(balanceInfo.getConsensusLock())).add(new BigInteger(balanceInfo.getTimeLock())).toString());
                    balanceInfo.setNonceType((Integer)map.get("nonceType"));
                    resultMap.put(assetKey, balanceInfo);
                }
                return new Result(resultMap);
            });
        }
        catch (NulsRuntimeException e) {
            Log.error(e);
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<AccountBalanceWithDecimals> getBalanceAndNonceWithDecimals(int chainId, int assetChainId, int assetId, String address) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("assetChainId", assetChainId);
        params.put("address", address);
        params.put("assetId", assetId);
        try {
            return this.callRpc(ModuleE.LG.abbr, "getBalanceNonce", params, map -> {
                if (map == null) {
                    return null;
                }
                AccountBalanceWithDecimals balanceInfo = new AccountBalanceWithDecimals();
                balanceInfo.setBalance(map.get("available").toString());
                balanceInfo.setTimeLock(map.get("timeHeightLocked").toString());
                balanceInfo.setConsensusLock(map.get("permanentLocked").toString());
                balanceInfo.setFreeze(map.get("freeze").toString());
                balanceInfo.setNonce((String)map.get("nonce"));
                balanceInfo.setTotalBalance(new BigInteger(balanceInfo.getBalance()).add(new BigInteger(balanceInfo.getConsensusLock())).add(new BigInteger(balanceInfo.getTimeLock())).toString());
                balanceInfo.setNonceType((Integer)map.get("nonceType"));
                AssetInfo assetInfo = this.ledgerAssetCache.getAssetInfo(assetChainId, assetId);
                if (assetInfo != null) {
                    balanceInfo.setDecimals(assetInfo.getDecimals());
                }
                return new Result((Object)balanceInfo);
            });
        }
        catch (NulsRuntimeException e) {
            Log.error(e);
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<Map> getAllAsset(int chainId) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("chainId", chainId);
        try {
            return this.callRpc(ModuleE.LG.abbr, "lg_get_all_asset", params, map -> {
                if (map == null) {
                    return null;
                }
                List assets = (List)map.get("assets");
                return new Result(assets);
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<AssetInfo> getAsset(int assetChainId, int assetId) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("chainId", assetChainId);
        params.put("assetId", assetId);
        try {
            return this.callRpc(ModuleE.LG.abbr, "getAssetRegInfoByAssetId", params, map -> {
                if (map == null || map.get("assetSymbol") == null) {
                    return Result.fail((String)CommonCodeConstanst.DATA_NOT_FOUND.getCode(), null);
                }
                int decimalPlace = Integer.parseInt(map.get("decimalPlace").toString());
                String symbol = map.get("assetSymbol").toString();
                return new Result((Object)new AssetInfo(assetChainId, assetId, symbol, decimalPlace));
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<List<AccountBalanceWithDecimals>> getBalanceWithDecimalsList(int chainId, List<Map> coinDtoList, String address) {
        try {
            Map _resultMap1;
            ArrayList<AccountBalanceWithDecimals> accountBalanceList = new ArrayList<AccountBalanceWithDecimals>();
            ArrayList<String> assetKeyList = new ArrayList<String>();
            ArrayList<Boolean> isConfirmedList = new ArrayList<Boolean>();
            ArrayList<String> contractList = new ArrayList<String>();
            ArrayList<String> methods = new ArrayList<String>();
            ArrayList<String> pars = new ArrayList<String>();
            for (int i = 0; i < coinDtoList.size(); ++i) {
                Map map = coinDtoList.get(i);
                int assetChainId = (Integer)map.get("chainId");
                int assetId = (Integer)map.get("assetId");
                String contractAddress = (String)map.get("contractAddress");
                if (StringUtils.isNotBlank((String)contractAddress)) {
                    contractList.add(contractAddress);
                    contractList.add(contractAddress);
                    contractList.add(contractAddress);
                    methods.add("balanceOf");
                    methods.add("lockedBalanceOf");
                    methods.add("decimals");
                    pars.add(address);
                    pars.add(address);
                    pars.add("");
                    continue;
                }
                assetKeyList.add(assetChainId + "-" + assetId);
                isConfirmedList.add(false);
            }
            LinkedHashMap resultMap1 = new LinkedHashMap();
            if (!assetKeyList.isEmpty() && (_resultMap1 = (Map)this.getBalanceAndNonceMap(chainId, assetKeyList, address, isConfirmedList).getData()) != null && !_resultMap1.isEmpty()) {
                _resultMap1.forEach((k, v) -> {
                    AssetInfo assetInfo = this.ledgerAssetCache.getAssetInfo(v.getAssetChainId(), v.getAssetId());
                    int decimals = 0;
                    if (assetInfo != null) {
                        decimals = assetInfo.getDecimals();
                    }
                    resultMap1.put(k, v.toAccountBalanceWithDecimals(decimals));
                });
            }
            LinkedHashMap<String, AccountBalanceWithDecimals> resultMap2 = new LinkedHashMap<String, AccountBalanceWithDecimals>();
            if (!contractList.isEmpty()) {
                Result<List<String>> multicall = this.contractTools.multicall(chainId, 0, contractList, methods, pars);
                List dataList = (List)multicall.getData();
                for (int i = 0; i < contractList.size(); i += 3) {
                    String decimalsStr;
                    String lockedStr;
                    String contractAddress = (String)contractList.get(i);
                    String availableStr = (String)dataList.get(i);
                    if (StringUtils.isBlank((String)availableStr)) {
                        availableStr = "0";
                    }
                    if (StringUtils.isBlank((String)(lockedStr = (String)dataList.get(i + 1)))) {
                        lockedStr = "0";
                    }
                    if (StringUtils.isBlank((String)(decimalsStr = (String)dataList.get(i + 2)))) {
                        decimalsStr = "0";
                    }
                    AccountBalanceWithDecimals accountBalance = new AccountBalanceWithDecimals();
                    accountBalance.setAssetChainId(0);
                    accountBalance.setAssetId(0);
                    accountBalance.setContractAddress(contractAddress);
                    accountBalance.setBalance(availableStr);
                    accountBalance.setTotalBalance(new BigInteger(availableStr).add(new BigInteger(lockedStr)).toString());
                    accountBalance.setConsensusLock(lockedStr);
                    accountBalance.setTimeLock("0");
                    accountBalance.setFreeze("0");
                    accountBalance.setDecimals(Integer.parseInt(decimalsStr));
                    resultMap2.put(contractAddress, accountBalance);
                }
            }
            LinkedHashMap allDataMap = new LinkedHashMap();
            allDataMap.putAll(resultMap1);
            allDataMap.putAll(resultMap2);
            for (int i = 0; i < coinDtoList.size(); ++i) {
                Map map = coinDtoList.get(i);
                int assetChainId = (Integer)map.get("chainId");
                int assetId = (Integer)map.get("assetId");
                String contractAddress = (String)map.get("contractAddress");
                if (StringUtils.isNotBlank((String)contractAddress)) {
                    accountBalanceList.add((AccountBalanceWithDecimals)allDataMap.get(contractAddress));
                    continue;
                }
                accountBalanceList.add((AccountBalanceWithDecimals)allDataMap.get(assetChainId + "-" + assetId));
            }
            return new Result(accountBalanceList);
        }
        catch (NulsRuntimeException e) {
            Log.error(e);
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<List<AccountBalance>> getBalanceList(int chainId, List<Map> coinDtoList, String address) {
        try {
            ArrayList<AccountBalance> accountBalanceList = new ArrayList<AccountBalance>();
            ArrayList<String> assetKeyList = new ArrayList<String>();
            ArrayList<Boolean> isConfirmedList = new ArrayList<Boolean>();
            ArrayList<String> contractList = new ArrayList<String>();
            ArrayList<String> methods = new ArrayList<String>();
            ArrayList<String> pars = new ArrayList<String>();
            for (int i = 0; i < coinDtoList.size(); ++i) {
                Map map = coinDtoList.get(i);
                int assetChainId = (Integer)map.get("chainId");
                int assetId = (Integer)map.get("assetId");
                String contractAddress = (String)map.get("contractAddress");
                if (StringUtils.isNotBlank((String)contractAddress)) {
                    contractList.add(contractAddress);
                    contractList.add(contractAddress);
                    methods.add("balanceOf");
                    methods.add("lockedBalanceOf");
                    pars.add(address);
                    pars.add(address);
                    continue;
                }
                assetKeyList.add(assetChainId + "-" + assetId);
                isConfirmedList.add(false);
            }
            Map resultMap1 = new LinkedHashMap();
            if (!assetKeyList.isEmpty() && (resultMap1 = (Map)this.getBalanceAndNonceMap(chainId, assetKeyList, address, isConfirmedList).getData()) == null) {
                resultMap1 = new LinkedHashMap();
            }
            LinkedHashMap<String, AccountBalance> resultMap2 = new LinkedHashMap<String, AccountBalance>();
            if (!contractList.isEmpty()) {
                Result<List<String>> multicall = this.contractTools.multicall(chainId, 0, contractList, methods, pars);
                List dataList = (List)multicall.getData();
                for (int i = 0; i < contractList.size(); i += 2) {
                    String lockedStr;
                    String contractAddress = (String)contractList.get(i);
                    String availableStr = (String)dataList.get(i);
                    if (StringUtils.isBlank((String)availableStr)) {
                        availableStr = "0";
                    }
                    if (StringUtils.isBlank((String)(lockedStr = (String)dataList.get(i + 1)))) {
                        lockedStr = "0";
                    }
                    AccountBalance accountBalance = new AccountBalance();
                    accountBalance.setAssetChainId(0);
                    accountBalance.setAssetId(0);
                    accountBalance.setContractAddress(contractAddress);
                    accountBalance.setBalance(availableStr);
                    accountBalance.setTotalBalance(new BigInteger(availableStr).add(new BigInteger(lockedStr)).toString());
                    accountBalance.setConsensusLock(lockedStr);
                    accountBalance.setTimeLock("0");
                    accountBalance.setFreeze("0");
                    resultMap2.put(contractAddress, accountBalance);
                }
            }
            LinkedHashMap allDataMap = new LinkedHashMap();
            allDataMap.putAll(resultMap1);
            allDataMap.putAll(resultMap2);
            for (int i = 0; i < coinDtoList.size(); ++i) {
                Map map = coinDtoList.get(i);
                int assetChainId = (Integer)map.get("chainId");
                int assetId = (Integer)map.get("assetId");
                String contractAddress = (String)map.get("contractAddress");
                if (StringUtils.isNotBlank((String)contractAddress)) {
                    accountBalanceList.add((AccountBalance)allDataMap.get(contractAddress));
                    continue;
                }
                accountBalanceList.add((AccountBalance)allDataMap.get(assetChainId + "-" + assetId));
            }
            return new Result(accountBalanceList);
        }
        catch (NulsRuntimeException e) {
            Log.error(e);
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }
}

