/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.rpctools;

import io.nuls.base.api.provider.Result;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.Transaction;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.log.Log;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.provider.model.dto.TransactionDto;
import io.nuls.provider.rpctools.CallRpc;
import io.nuls.provider.rpctools.vo.TxRegisterDetail;
import io.nuls.provider.utils.ResultUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

@Component
public class TransactionTools
implements CallRpc {
    public Result validateTx(int chainId, String txStr) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("chainId", chainId);
        params.put("tx", txStr);
        try {
            return this.callRpc(ModuleE.TX.abbr, "tx_verifyTx", params, res -> new Result(res));
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result newTx(int chainId, String txStr) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("chainId", chainId);
        params.put("tx", txStr);
        try {
            return this.callRpc(ModuleE.TX.abbr, "tx_newTx", params, res -> new Result(res));
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result broadcastTxWithoutAnyValidation(int chainId, String txStr) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("chainId", chainId);
        params.put("tx", txStr);
        try {
            return this.callRpc(ModuleE.TX.abbr, "tx_broadcast", params, res -> new Result(res));
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public boolean registerTx(int chainId, String moduleName, int ... txTyps) {
        try {
            ArrayList txRegisterDetailList = new ArrayList();
            Arrays.stream(txTyps).forEach(txType -> {
                TxRegisterDetail detail = new TxRegisterDetail();
                detail.setSystemTx(false);
                detail.setTxType(txType);
                detail.setUnlockTx(false);
                detail.setVerifySignature(true);
                detail.setVerifyFee(true);
                txRegisterDetailList.add(detail);
            });
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("version", "1.0");
            params.put("chainId", chainId);
            params.put("moduleCode", moduleName);
            params.put("list", txRegisterDetailList);
            params.put("delList", List.of());
            return this.callRpc(ModuleE.TX.abbr, "tx_register", params, res -> (Boolean)res.get("value"));
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
            return true;
        }
    }

    public Result<String> getTxHex(int chainId, String txHash) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("txHash", txHash);
        try {
            return this.callRpc(ModuleE.TX.abbr, "tx_getTxClient", params, res -> {
                if (res == null || res.get("tx") == null) {
                    return Result.fail((String)CommonCodeConstanst.DATA_NOT_FOUND.getCode(), (String)CommonCodeConstanst.DATA_NOT_FOUND.getMsg());
                }
                String txStr = (String)res.get("tx");
                return new Result((Object)txStr);
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<TransactionDto> getTx(int chainId, String txHash) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("txHash", txHash);
        try {
            return this.callRpc(ModuleE.TX.abbr, "tx_getTxClient", params, res -> {
                if (res == null || res.get("tx") == null) {
                    return Result.fail((String)CommonCodeConstanst.DATA_NOT_FOUND.getCode(), (String)CommonCodeConstanst.DATA_NOT_FOUND.getMsg());
                }
                String txStr = (String)res.get("tx");
                Long height = Long.parseLong(res.get("height").toString());
                Integer status = (Integer)res.get("status");
                Transaction tx = new Transaction();
                try {
                    tx.parse(new NulsByteBuffer(HexUtil.decode((String)txStr)));
                    TransactionDto txDto = new TransactionDto(tx);
                    txDto.setBlockHeight(height);
                    txDto.setStatus(status);
                    return new Result((Object)txDto);
                }
                catch (NulsException e) {
                    return ResultUtil.getNulsExceptionResult(e);
                }
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<TransactionDto> getConfirmedTx(int chainId, String txHash) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("txHash", txHash);
        try {
            return this.callRpc(ModuleE.TX.abbr, "tx_getConfirmedTxClient", params, res -> {
                if (res == null || res.get("tx") == null) {
                    return Result.fail((String)CommonCodeConstanst.DATA_NOT_FOUND.getCode(), (String)CommonCodeConstanst.DATA_NOT_FOUND.getMsg());
                }
                String txStr = (String)res.get("tx");
                Long height = Long.parseLong(res.get("height").toString());
                Integer status = (Integer)res.get("status");
                Transaction tx = new Transaction();
                try {
                    tx.parse(new NulsByteBuffer(HexUtil.decode((String)txStr)));
                    TransactionDto txDto = new TransactionDto(tx);
                    txDto.setBlockHeight(height);
                    txDto.setStatus(status);
                    return new Result((Object)txDto);
                }
                catch (NulsException e) {
                    return ResultUtil.getNulsExceptionResult(e);
                }
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }
}

