/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.core.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.nuls.core.core.config.ConfigSetting;
import io.nuls.core.core.config.ConfigurationLoader;
import io.nuls.core.core.config.ModuleConfigParser;
import io.nuls.core.io.IoUtils;
import io.nuls.core.parse.JSONUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class JsonModuleConfigParser
implements ModuleConfigParser {
    @Override
    public String fileSuffix() {
        return "json";
    }

    @Override
    public Map<String, Map<String, ConfigurationLoader.ConfigItem>> parse(String configFile, InputStream inputStream) {
        try {
            String configJson = IoUtils.readRealPath(inputStream);
            Map<String, Object> data = JSONUtils.json2map(configJson);
            HashMap res = new HashMap(data.size());
            data.forEach((key, value) -> {
                try {
                    if (ConfigSetting.isPrimitive(value.getClass())) {
                        res.put(key, new ConfigurationLoader.ConfigItem(configFile, String.valueOf(value)));
                    } else {
                        res.put(key, new ConfigurationLoader.ConfigItem(configFile, JSONUtils.obj2json(value)));
                    }
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("jsonConfiguration file parsing error\uff1a" + key);
                }
            });
            return Map.of("global", res);
        }
        catch (Exception e) {
            throw new RuntimeException("jsonConfiguration file parsing error");
        }
    }
}

