/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.crypto;

import java.util.Arrays;
import java.util.Objects;

public final class EncryptedData {
    public static byte[] DEFAULT_IV = new byte[16];
    private byte[] initialisationVector;
    private byte[] encryptedBytes;

    public EncryptedData(byte[] initialisationVector, byte[] encryptedBytes) {
        this.initialisationVector = Arrays.copyOf(initialisationVector, initialisationVector.length);
        this.encryptedBytes = Arrays.copyOf(encryptedBytes, encryptedBytes.length);
    }

    public EncryptedData(byte[] encryptedBytes) {
        this(DEFAULT_IV, encryptedBytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptedData other = (EncryptedData)o;
        return Arrays.equals(this.encryptedBytes, other.encryptedBytes) && Arrays.equals(this.initialisationVector, other.initialisationVector);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.encryptedBytes), Arrays.hashCode(this.initialisationVector));
    }

    public String toString() {
        return "EncryptedData [initialisationVector=" + Arrays.toString(this.initialisationVector) + ", encryptedPrivateKey=" + Arrays.toString(this.encryptedBytes) + "]";
    }

    public byte[] getInitialisationVector() {
        return this.initialisationVector;
    }

    public byte[] getEncryptedBytes() {
        return this.encryptedBytes;
    }

    public void setInitialisationVector(byte[] initialisationVector) {
        this.initialisationVector = initialisationVector;
    }

    public void setEncryptedBytes(byte[] encryptedBytes) {
        this.encryptedBytes = encryptedBytes;
    }
}

