/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.io;

import io.nuls.core.log.Log;
import io.nuls.core.model.ObjectUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;

public class IoUtils {
    private static final int SIZE = 8192;

    public static byte[] download(String urlStr) throws IOException {
        Log.info("Get the version info file from " + urlStr);
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(60000);
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        InputStream inputStream = conn.getInputStream();
        return IoUtils.readInputStream(inputStream);
    }

    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[inputStream.available()];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        return bos.toByteArray();
    }

    public static String read(String path) throws Exception {
        ObjectUtils.canNotEmpty(path, "null parameter");
        path = path.replaceAll("\\\\", "/");
        try (InputStream stream = IoUtils.class.getClassLoader().getResourceAsStream(path);){
            String string = IoUtils.readRealPath(stream);
            return string;
        }
    }

    public static String readRealPath(InputStream stream) throws Exception {
        InputStreamReader inReader = null;
        BufferedReader br = null;
        try {
            String line;
            inReader = new InputStreamReader(stream);
            br = new BufferedReader(inReader);
            StringBuilder str = new StringBuilder();
            while ((line = br.readLine()) != null) {
                str.append(line.trim());
            }
            String string = str.toString();
            return string;
        }
        catch (IOException e) {
            Log.error(e.getMessage());
            throw e;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (inReader != null) {
                    inReader.close();
                }
            }
            catch (Exception e) {
                Log.error(e.getMessage());
            }
        }
    }

    public static String readBytesToString(InputStream is) {
        return new String(IoUtils.readBytes(is));
    }

    public static String readBytesToString(InputStream is, String charsetName) {
        try {
            return new String(IoUtils.readBytes(is), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String readBytesToString(File file, String charsetName) {
        try {
            return new String(IoUtils.readBytes(file), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String readBytesToString(File file) {
        return new String(IoUtils.readBytes(file));
    }

    public static byte[] readBytes(InputStream is) {
        byte[] bytes = null;
        try {
            int len;
            BufferedInputStream bis = new BufferedInputStream(is);
            byte[] cbuf = new byte[8192];
            ByteArrayOutputStream outWriter = new ByteArrayOutputStream();
            while ((len = bis.read(cbuf)) != -1) {
                outWriter.write(cbuf, 0, len);
            }
            outWriter.flush();
            bis.close();
            is.close();
            bytes = outWriter.toByteArray();
            outWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytes;
    }

    public static char[] readChars(InputStream is, String charsetName) {
        char[] chars = null;
        try {
            int len;
            InputStreamReader isr = null;
            isr = charsetName == null ? new InputStreamReader(is) : new InputStreamReader(is, charsetName);
            BufferedReader br = new BufferedReader(isr);
            char[] cbuf = new char[8192];
            CharArrayWriter outWriter = new CharArrayWriter();
            while ((len = br.read(cbuf)) != -1) {
                outWriter.write(cbuf, 0, len);
            }
            outWriter.flush();
            br.close();
            isr.close();
            is.close();
            chars = outWriter.toCharArray();
            outWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return chars;
    }

    public static String readCharsToString(File file) {
        try {
            return IoUtils.readCharsToString(new FileInputStream(file), null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String readCharsToString(File file, String charset) {
        try {
            return IoUtils.readCharsToString(new FileInputStream(file), charset);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String readCharsToString(InputStream is) {
        return new String(IoUtils.readChars(is, null));
    }

    public static String readCharsToString(InputStream is, String charsetName) {
        return new String(IoUtils.readChars(is, charsetName));
    }

    public static byte[] readBytes(File file) {
        try {
            return IoUtils.readBytes(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static char[] readChars(File file, String charsetName) {
        try {
            return IoUtils.readChars(new FileInputStream(file), charsetName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeBytes(OutputStream os, byte[] text) {
        IoUtils.writeBytes(os, text, 0, text.length);
    }

    public static void writeBytes(OutputStream os, byte[] text, int off, int lenght) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(os);
            bos.write(text, off, lenght);
            bos.flush();
            bos.close();
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeChars(OutputStream os, char[] text, String charsetName) {
        IoUtils.writeChars(os, text, 0, text.length, charsetName);
    }

    public static void writeChars(OutputStream os, char[] text, int off, int lenght, String charsetName) {
        try {
            OutputStreamWriter osw = null;
            osw = charsetName == null ? new OutputStreamWriter(os) : new OutputStreamWriter(os, charsetName);
            BufferedWriter bw = new BufferedWriter(osw);
            bw.write(text, off, lenght);
            bw.flush();
            bw.close();
            osw.close();
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeString(File file, boolean append, String text) {
        IoUtils.writeString(file, append, text, 0, text.length(), null);
    }

    public static void writeString(File file, boolean append, String text, int off, int lenght, String charsetName) {
        try {
            IoUtils.writeString(new FileOutputStream(file, append), text, off, lenght, charsetName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void writeString(File file, String text) {
        IoUtils.writeString(file, false, text, 0, text.length(), null);
    }

    public static void writeString(File file, boolean append, String text, String charsetName) {
        IoUtils.writeString(file, append, text, 0, text.length(), charsetName);
    }

    public static void writeString(File file, String text, String charsetName) {
        IoUtils.writeString(file, false, text, 0, text.length(), charsetName);
    }

    public static void writeString(OutputStream os, String text, String charsetName) {
        IoUtils.writeString(os, text, 0, text.length(), charsetName);
    }

    public static void writeString(OutputStream os, String text, int off, int lenght, String charsetName) {
        try {
            OutputStreamWriter osw = null;
            osw = charsetName == null ? new OutputStreamWriter(os) : new OutputStreamWriter(os, charsetName);
            BufferedWriter bw = new BufferedWriter(osw);
            bw.write(text, off, lenght);
            bw.flush();
            bw.close();
            osw.close();
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

