/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.log;

import io.nuls.core.log.logback.LoggerBuilder;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.parse.JSONUtils;
import java.util.ArrayList;

public class Log {
    public static final String BASIC_NAME = "common";
    public static NulsLogger BASIC_LOGGER = LoggerBuilder.getLogger("common");

    public static void debug(String msg) {
        BASIC_LOGGER.debug(msg);
    }

    public static void debug(String msg, Object ... objs) {
        try {
            ArrayList<String> objStrs = new ArrayList<String>();
            for (Object obj : objs) {
                if (obj instanceof String) {
                    objStrs.add((String)obj);
                    continue;
                }
                objStrs.add(JSONUtils.obj2json(obj));
            }
            BASIC_LOGGER.debug(msg, objStrs.toArray());
        }
        catch (Exception e) {
            Log.error(e);
        }
    }

    public static void debug(String msg, Throwable throwable) {
        BASIC_LOGGER.debug(msg, throwable);
    }

    public static void info(String msg) {
        BASIC_LOGGER.info(msg);
    }

    public static void info(String msg, Object ... objs) {
        try {
            ArrayList<String> objStrs = new ArrayList<String>();
            for (Object obj : objs) {
                if (obj instanceof String) {
                    objStrs.add((String)obj);
                    continue;
                }
                objStrs.add(JSONUtils.obj2json(obj));
            }
            BASIC_LOGGER.info(msg, objStrs.toArray());
        }
        catch (Exception e) {
            Log.error(e);
        }
    }

    public static void info(String msg, Throwable throwable) {
        BASIC_LOGGER.info(msg, throwable);
    }

    public static void warn(String msg) {
        BASIC_LOGGER.warn(msg);
    }

    public static void warn(String msg, Object ... objs) {
        try {
            ArrayList<String> objStrs = new ArrayList<String>();
            for (Object obj : objs) {
                if (obj instanceof String) {
                    objStrs.add((String)obj);
                    continue;
                }
                objStrs.add(JSONUtils.obj2json(obj));
            }
            BASIC_LOGGER.warn(msg, objStrs.toArray());
        }
        catch (Exception e) {
            Log.error(e);
        }
    }

    public static void warn(String msg, Throwable throwable) {
        BASIC_LOGGER.warn(msg, throwable);
    }

    public static void warn(Throwable throwable) {
        BASIC_LOGGER.warn("", throwable);
    }

    public static void error(String msg) {
        BASIC_LOGGER.error(msg);
    }

    public static void error(String msg, Object ... objs) {
        try {
            ArrayList<Object> objStrs = new ArrayList<Object>();
            for (Object obj : objs) {
                if (obj instanceof String) {
                    objStrs.add(obj);
                    continue;
                }
                if (obj instanceof Throwable) {
                    objStrs.add(obj);
                    continue;
                }
                objStrs.add(JSONUtils.obj2json(obj));
            }
            BASIC_LOGGER.error(msg, objStrs.toArray());
        }
        catch (Exception e) {
            Log.error(e);
        }
    }

    public static void error(String msg, Throwable throwable) {
        BASIC_LOGGER.error(msg, throwable);
    }

    public static void error(Throwable throwable) {
        BASIC_LOGGER.error(throwable);
    }

    public static void trace(String msg) {
        BASIC_LOGGER.trace(msg);
    }

    public static void trace(String msg, Throwable throwable) {
        BASIC_LOGGER.trace(msg, throwable);
    }
}

