/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rockdb.model;

import java.util.Comparator;
import java.util.Objects;

public class Entry<K, V>
implements Comparable<K> {
    private final K key;
    private V value;
    private Comparator<K> comparator;

    public Entry(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public Entry(K key, V value, Comparator<K> comparator) {
        this.key = key;
        this.value = value;
        this.comparator = comparator;
    }

    public final K getKey() {
        return this.key;
    }

    public final V getValue() {
        return this.value;
    }

    public final String toString() {
        return this.key + "=" + this.value;
    }

    public final int hashCode() {
        return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
    }

    public final boolean equals(Object o) {
        Entry e;
        if (o == this) {
            return true;
        }
        return o instanceof Entry && Objects.equals(this.key, (e = (Entry)o).getKey()) && Objects.equals(this.value, e.getValue());
    }

    @Override
    public int compareTo(K thatKey) {
        return this.comparator.compare(this.key, thatKey);
    }
}

