/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rockdb.service;

import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rockdb.manager.RocksDBManager;
import io.nuls.core.rockdb.model.Entry;
import io.nuls.core.rockdb.service.BatchOperation;
import io.nuls.core.rockdb.service.RocksDBBatchOperation;
import java.util.List;
import java.util.Map;

public class RocksDBService {
    public static void init(String path) {
        try {
            RocksDBManager.init(path);
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Throwable)e);
        }
    }

    public static boolean createTable(String tableName) throws Exception {
        if (!RocksDBService.existTable(tableName)) {
            return RocksDBManager.createTable(tableName);
        }
        return false;
    }

    public static boolean destroyTable(String table) throws Exception {
        return RocksDBManager.destroyTable(table);
    }

    public static String[] listTable() {
        return RocksDBManager.listTable();
    }

    public static boolean createTableIfNotExist(String table) throws Exception {
        boolean exist = RocksDBService.existTable(table);
        if (!exist) {
            RocksDBService.createTable(table);
        }
        return exist;
    }

    public static boolean existTable(String table) {
        return RocksDBManager.getTable(table) != null;
    }

    public static boolean put(String table, byte[] key, byte[] value) throws Exception {
        return RocksDBManager.put(table, key, value);
    }

    public static boolean delete(String table, byte[] key) throws Exception {
        return RocksDBManager.delete(table, key);
    }

    public static boolean batchPut(String table, Map<byte[], byte[]> kvs) throws Exception {
        return RocksDBManager.batchPut(table, kvs);
    }

    public static boolean deleteKeys(String table, List<byte[]> keys) throws Exception {
        return RocksDBManager.deleteKeys(table, keys);
    }

    public static byte[] get(String table, byte[] key) {
        return RocksDBManager.get(table, key);
    }

    public static boolean keyMayExist(String table, byte[] key) {
        return RocksDBManager.keyMayExist(table, key);
    }

    public static List<byte[]> multiGet(String table, List<byte[]> keys) {
        return RocksDBManager.multiGet(table, keys);
    }

    public static List<byte[]> multiGetAsList(String table, List<byte[]> keys) {
        return RocksDBManager.multiGetAsList(table, keys);
    }

    public static List<byte[]> multiGetValueList(String table, List<byte[]> keys) {
        return RocksDBManager.multiGetValueList(table, keys);
    }

    public static List<byte[]> multiGetKeyList(String table, List<byte[]> keys) {
        return RocksDBManager.multiGetKeyList(table, keys);
    }

    public static List<byte[]> keyList(String table) {
        return RocksDBManager.keyList(table);
    }

    public static List<byte[]> valueList(String table) {
        return RocksDBManager.valueList(table);
    }

    public static List<Entry<byte[], byte[]>> entryList(String table) {
        return RocksDBManager.entryList(table);
    }

    public static BatchOperation createWriteBatch(String table) {
        if (StringUtils.isBlank((String)table)) {
            return null;
        }
        RocksDBBatchOperation batchOperation = new RocksDBBatchOperation(table);
        boolean result = false;
        try {
            result = batchOperation.checkBatch();
        }
        catch (Exception e) {
            Log.error((String)("DB batch create error: " + e.getMessage()));
        }
        if (!result) {
            return null;
        }
        return batchOperation;
    }
}

