/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rockdb.util;

import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.config.IniEntity;
import java.io.File;
import java.net.URL;
import org.ini4j.Config;
import org.ini4j.Ini;

public class DBUtils {
    public static File loadDataPath(String path) {
        File dir;
        String unixPathSeparator = ":";
        String pathSeparator = System.getProperty("path.separator");
        if (unixPathSeparator.equals(pathSeparator)) {
            String rootPath = "/";
            if (path.startsWith(rootPath)) {
                dir = new File(path);
            } else {
                Log.debug((String)("path=" + path));
                Log.debug((String)("genAbsolutePath(path)=" + DBUtils.genAbsolutePath(path)));
                dir = new File(DBUtils.genAbsolutePath(path));
            }
        } else {
            String rootPath = "^[c-zC-Z]:.*";
            dir = path.matches(rootPath) ? new File(path) : new File(DBUtils.genAbsolutePath(path));
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private static String getProjectDbPath() throws Exception {
        Config cfg = new Config();
        cfg.setMultiSection(true);
        Ini ini = new Ini();
        ini.setConfig(cfg);
        ini.load(new File("module.ncf"));
        IniEntity ie = new IniEntity(ini);
        String filePath = ie.getCfgValue("Module", "DataPath");
        return filePath;
    }

    public static String genAbsolutePath(String path) {
        File file = new File(path);
        if (file.exists() && file.isAbsolute()) {
            return path;
        }
        String[] paths = path.split("/|\\\\");
        URL resource = ClassLoader.getSystemClassLoader().getResource(".");
        String classPath = "";
        if (resource == null) {
            URL url = DBUtils.class.getProtectionDomain().getCodeSource().getLocation();
            classPath = url.getPath();
        } else {
            classPath = resource.getPath();
        }
        file = new File(classPath);
        String resultPath = null;
        boolean isFileName = false;
        for (String p : paths) {
            if (StringUtils.isBlank((String)p)) continue;
            if (!isFileName) {
                if ("..".equals(p)) {
                    file = file.getParentFile();
                    continue;
                }
                if (".".equals(p)) continue;
                isFileName = true;
                resultPath = file.getPath() + File.separator + p;
                continue;
            }
            resultPath = resultPath + File.separator + p;
        }
        return resultPath;
    }

    public static String getAreaNameFromDbPath(String dbPath) {
        int end = dbPath.lastIndexOf(File.separator);
        int start = dbPath.lastIndexOf(File.separator, end - 1) + 1;
        return dbPath.substring(start, end);
    }

    public static boolean checkPathLegal(String areaName) {
        if (StringUtils.isBlank((String)areaName)) {
            return false;
        }
        String regex = "^[a-zA-Z0-9_\\-]+$";
        return areaName.matches(regex);
    }
}

