/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.v2.service;

import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.v2.model.dto.BlockDto;
import io.nuls.v2.model.dto.BlockHeaderDto;
import io.nuls.v2.model.dto.RestFulResult;
import io.nuls.v2.util.RestFulUtil;
import io.nuls.v2.util.ValidateUtil;
import java.util.Map;

public class BlockService {
    private static BlockService instance = new BlockService();

    private BlockService() {
    }

    public static BlockService getInstance() {
        return instance;
    }

    public Result getBlockHeader(long height) {
        Result result;
        ValidateUtil.validateChainId();
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/block/header/height/" + height);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(null);
            Map<String, Object> map = restFulResult.getData();
            BlockHeaderDto dto = BlockHeaderDto.mapToPojo(map);
            result.setData((Object)dto);
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result getBlockHeader(String hash) {
        Result result;
        ValidateUtil.validateChainId();
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/block/header/hash/" + hash);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(null);
            Map<String, Object> map = restFulResult.getData();
            BlockHeaderDto dto = BlockHeaderDto.mapToPojo(map);
            result.setData((Object)dto);
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result getBestBlockHeader() {
        Result result;
        ValidateUtil.validateChainId();
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/block/header/newest");
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(null);
            Map<String, Object> map = restFulResult.getData();
            BlockHeaderDto dto = BlockHeaderDto.mapToPojo(map);
            result.setData((Object)dto);
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result getBlock(long height) {
        Result result;
        ValidateUtil.validateChainId();
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/block/height/" + height);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(null);
            Map<String, Object> map = restFulResult.getData();
            BlockDto dto = BlockDto.mapToPojo(map);
            result.setData((Object)dto);
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result getBlock(String hash) {
        Result result;
        ValidateUtil.validateChainId();
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/block/hash/" + hash);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(null);
            Map<String, Object> map = restFulResult.getData();
            BlockDto dto = BlockDto.mapToPojo(map);
            result.setData((Object)dto);
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result getBestBlock() {
        Result result;
        ValidateUtil.validateChainId();
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/block/newest");
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(null);
            Map<String, Object> map = restFulResult.getData();
            BlockDto dto = BlockDto.mapToPojo(map);
            result.setData((Object)dto);
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result getInfo() {
        Result result;
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/info");
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }
}

