/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.v2.util;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.TransactionFeeCalculator;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.core.basic.NulsData;
import io.nuls.core.basic.Result;
import io.nuls.core.basic.VarInt;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.LongUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.v2.error.ContractErrorCode;
import io.nuls.v2.model.dto.AccountAmountDto;
import io.nuls.v2.model.dto.ProgramMultyAssetValue;
import io.nuls.v2.tx.CallContractTransaction;
import io.nuls.v2.tx.CreateContractTransaction;
import io.nuls.v2.tx.DeleteContractTransaction;
import io.nuls.v2.txdata.CallContractData;
import io.nuls.v2.txdata.ContractData;
import io.nuls.v2.txdata.CreateContractData;
import io.nuls.v2.txdata.DeleteContractData;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;

public class ContractUtil {
    public static String[][] twoDimensionalArray(Object[] args, String[] types) {
        if (args == null) {
            return null;
        }
        int length = args.length;
        String[][] two = new String[length][];
        for (int i = 0; i < length; ++i) {
            Object arg = args[i];
            if (arg == null) {
                two[i] = new String[0];
                continue;
            }
            if (arg instanceof String) {
                String argStr = (String)arg;
                if (types != null && StringUtils.isBlank((String)argStr) && !"String".equalsIgnoreCase(types[i])) {
                    two[i] = new String[0];
                    continue;
                }
                two[i] = new String[]{argStr};
                continue;
            }
            if (arg.getClass().isArray()) {
                int len = Array.getLength(arg);
                String[] result = new String[len];
                for (int k = 0; k < len; ++k) {
                    result[k] = ContractUtil.valueOf(Array.get(arg, k));
                }
                two[i] = result;
                continue;
            }
            if (arg instanceof List) {
                List resultArg = (List)arg;
                int size = resultArg.size();
                String[] result = new String[size];
                for (int k = 0; k < size; ++k) {
                    result[k] = ContractUtil.valueOf(resultArg.get(k));
                }
                two[i] = result;
                continue;
            }
            two[i] = new String[]{ContractUtil.valueOf(arg)};
        }
        return two;
    }

    public static byte[] extractContractAddressFromTxData(Transaction tx) {
        if (tx == null) {
            return null;
        }
        int txType = tx.getType();
        if (txType == 15 || txType == 16 || txType == 17) {
            return ContractUtil.extractContractAddressFromTxData(tx.getTxData());
        }
        return null;
    }

    private static byte[] extractContractAddressFromTxData(byte[] txData) {
        if (txData == null) {
            return null;
        }
        int length = txData.length;
        if (length < 46) {
            return null;
        }
        byte[] contractAddress = new byte[23];
        System.arraycopy(txData, 23, contractAddress, 0, 23);
        return contractAddress;
    }

    public static String[][] twoDimensionalArray(Object[] args) {
        return ContractUtil.twoDimensionalArray(args, null);
    }

    public static String valueOf(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public static boolean isContractTransaction(Transaction tx) {
        if (tx == null) {
            return false;
        }
        int txType = tx.getType();
        return txType == 15 || txType == 16 || txType == 17 || txType == 18 || txType == 19;
    }

    public static boolean isGasCostContractTransaction(Transaction tx) {
        if (tx == null) {
            return false;
        }
        int txType = tx.getType();
        return txType == 15 || txType == 16;
    }

    public static boolean isLockContract(long lastestHeight, long blockHeight) throws NulsException {
        long confirmCount;
        return blockHeight > 0L && (confirmCount = lastestHeight - blockHeight) < 7L;
    }

    public static String bigInteger2String(BigInteger bigInteger) {
        if (bigInteger == null) {
            return "0";
        }
        return bigInteger.toString();
    }

    public static String simplifyErrorMsg(String errorMsg) {
        String resultMsg = "contract error - ";
        if (StringUtils.isBlank((String)errorMsg)) {
            return resultMsg;
        }
        if (errorMsg.contains("Exception:")) {
            String[] msgs = errorMsg.split("Exception:", 2);
            return resultMsg + msgs[1].trim();
        }
        return resultMsg + errorMsg;
    }

    public static Result checkVmResultAndReturn(String errorMessage, Result defaultResult) {
        if (StringUtils.isBlank((String)errorMessage)) {
            return defaultResult;
        }
        if (ContractUtil.isNotEnoughGasError(errorMessage)) {
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_GAS_LIMIT);
        }
        return defaultResult;
    }

    private static boolean isNotEnoughGasError(String errorMessage) {
        if (errorMessage == null) {
            return false;
        }
        return errorMessage.contains("not enough gas");
    }

    public static boolean isTerminatedContract(int status) {
        return 2 == status;
    }

    public static boolean isTransferMethod(String method) {
        return "transfer".equals(method) || "transferFrom".equals(method);
    }

    public static String argToString(String[][] args) {
        if (args == null) {
            return "";
        }
        String result = "";
        for (Object[] objectArray : args) {
            result = result + Arrays.toString(objectArray) + "| ";
        }
        return result;
    }

    public static boolean isLegalContractAddress(int chainId, byte[] addressBytes) {
        if (addressBytes == null) {
            return false;
        }
        return AddressTool.validContractAddress((byte[])addressBytes, (int)chainId);
    }

    public static Result getSuccess() {
        return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS);
    }

    public static Result getFailed() {
        return Result.getFailed((ErrorCode)CommonCodeConstanst.FAILED);
    }

    public static String asString(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] asBytes(String string) {
        return Base64.getDecoder().decode(string);
    }

    public static BigInteger minus(BigInteger a, BigInteger b) {
        BigInteger result = a.subtract(b);
        if (result.compareTo(BigInteger.ZERO) < 0) {
            throw new RuntimeException("Negative number detected.");
        }
        return result;
    }

    public static int extractTxTypeFromTx(String txString) throws NulsException {
        String txTypeHexString = txString.substring(0, 4);
        NulsByteBuffer byteBuffer = new NulsByteBuffer(RPCUtil.decode((String)txTypeHexString));
        return byteBuffer.readUint16();
    }

    public static String toString(String[][] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(Arrays.toString(a[i]));
            if (i == iMax) break;
            b.append(", ");
            ++i;
        }
        b.append(']');
        return b.toString();
    }

    public static CreateContractTransaction newCreateTx(int chainId, int assetsId, BigInteger senderBalance, String nonce, CreateContractData createContractData, String remark) {
        try {
            CreateContractTransaction tx = new CreateContractTransaction();
            if (StringUtils.isNotBlank((String)remark)) {
                tx.setRemark(remark.getBytes(StandardCharsets.UTF_8));
            }
            tx.setTime(System.currentTimeMillis() / 1000L);
            CoinData coinData = ContractUtil.makeCoinData(chainId, assetsId, senderBalance, nonce, createContractData, tx.size(), ContractUtil.calcSize((NulsData)createContractData));
            tx.setTxDataObj(createContractData);
            tx.setCoinDataObj(coinData);
            tx.serializeData();
            return tx;
        }
        catch (IOException e) {
            Log.error((Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public static CallContractTransaction newCallTx(int chainId, int assetId, BigInteger senderBalance, String nonce, CallContractData callContractData, String remark, List<ProgramMultyAssetValue> multyAssetValues, List<AccountAmountDto> nulsValueToOthers) {
        return ContractUtil.newCallTx(chainId, assetId, senderBalance, nonce, callContractData, 0L, remark, multyAssetValues, nulsValueToOthers);
    }

    public static CallContractTransaction newCallTx(int chainId, int assetId, BigInteger senderBalance, String nonce, CallContractData callContractData, long time, String remark, List<ProgramMultyAssetValue> multyAssetValues, List<AccountAmountDto> nulsValueToOthers) {
        try {
            CallContractTransaction tx = new CallContractTransaction();
            if (StringUtils.isNotBlank((String)remark)) {
                tx.setRemark(remark.getBytes(StandardCharsets.UTF_8));
            }
            if (time == 0L) {
                tx.setTime(System.currentTimeMillis() / 1000L);
            } else {
                tx.setTime(time);
            }
            byte[] sender = callContractData.getSender();
            BigInteger value = callContractData.getValue();
            byte[] contractAddress = callContractData.getContractAddress();
            ArrayList<CoinFrom> froms = new ArrayList<CoinFrom>();
            ArrayList<CoinTo> tos = new ArrayList<CoinTo>();
            if (value.compareTo(BigInteger.ZERO) > 0) {
                CoinFrom coinFrom = new CoinFrom(sender, chainId, assetId, value, RPCUtil.decode((String)nonce), 0);
                froms.add(coinFrom);
                CoinTo coinTo = new CoinTo(contractAddress, chainId, assetId, value);
                tos.add(coinTo);
            }
            if (multyAssetValues != null) {
                for (ProgramMultyAssetValue multyAssetValue : multyAssetValues) {
                    BigInteger _value = multyAssetValue.getValue();
                    int _assetChainId = multyAssetValue.getAssetChainId();
                    int _assetId = multyAssetValue.getAssetId();
                    CoinFrom coinFrom = new CoinFrom(sender, _assetChainId, _assetId, _value, RPCUtil.decode((String)multyAssetValue.getNonce()), 0);
                    froms.add(coinFrom);
                    CoinTo coinTo = new CoinTo(contractAddress, _assetChainId, _assetId, _value);
                    tos.add(coinTo);
                }
            }
            CoinData coinData = new CoinData();
            coinData.setFrom(froms);
            coinData.setTo(tos);
            long gasUsed = callContractData.getGasLimit();
            BigInteger imputedValue = BigInteger.valueOf(LongUtils.mul((long)gasUsed, (long)callContractData.getPrice()));
            byte[] feeAccountBytes = sender;
            BigInteger feeValue = imputedValue;
            if (nulsValueToOthers != null && !nulsValueToOthers.isEmpty()) {
                for (AccountAmountDto accountAmountDto : nulsValueToOthers) {
                    feeValue = feeValue.add(accountAmountDto.getValue());
                    coinData.addTo(new CoinTo(AddressTool.getAddress((String)accountAmountDto.getTo()), chainId, assetId, accountAmountDto.getValue()));
                }
            }
            CoinFrom feeAccountFrom = null;
            for (CoinFrom from : froms) {
                int _assetChainId = from.getAssetsChainId();
                int _assetId = from.getAssetsId();
                if (!Arrays.equals(from.getAddress(), feeAccountBytes) || _assetChainId != chainId || _assetId != assetId) continue;
                from.setAmount(from.getAmount().add(feeValue));
                feeAccountFrom = from;
                break;
            }
            if (feeAccountFrom == null) {
                feeAccountFrom = new CoinFrom(feeAccountBytes, chainId, assetId, feeValue, RPCUtil.decode((String)nonce), 0);
                coinData.addFrom(feeAccountFrom);
            }
            tx.setCoinData(coinData.serialize());
            tx.setTxData(callContractData.serialize());
            BigInteger bigInteger = TransactionFeeCalculator.getNormalUnsignedTxFee((int)(tx.getSize() + 130));
            feeAccountFrom.setAmount(feeAccountFrom.getAmount().add(bigInteger));
            tx.setCoinData(coinData.serialize());
            return tx;
        }
        catch (IOException e) {
            Log.error((Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public static DeleteContractTransaction newDeleteTx(int chainId, int assetsId, BigInteger senderBalance, String nonce, DeleteContractData deleteContractData, String remark) {
        try {
            DeleteContractTransaction tx = new DeleteContractTransaction();
            if (StringUtils.isNotBlank((String)remark)) {
                tx.setRemark(remark.getBytes(StandardCharsets.UTF_8));
            }
            tx.setTime(System.currentTimeMillis() / 1000L);
            CoinData coinData = ContractUtil.makeCoinData(chainId, assetsId, senderBalance, nonce, deleteContractData, tx.size(), ContractUtil.calcSize((NulsData)deleteContractData));
            tx.setTxDataObj(deleteContractData);
            tx.setCoinDataObj(coinData);
            tx.serializeData();
            return tx;
        }
        catch (IOException e) {
            Log.error((Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    private static CoinData makeCoinData(int chainId, int assetsId, BigInteger senderBalance, String nonce, ContractData contractData, int txSize, int txDataSize) {
        BigInteger fee;
        CoinData coinData = new CoinData();
        long gasUsed = contractData.getGasLimit();
        BigInteger imputedValue = BigInteger.valueOf(LongUtils.mul((long)gasUsed, (long)contractData.getPrice()));
        BigInteger value = contractData.getValue();
        BigInteger totalValue = imputedValue.add(value);
        CoinFrom coinFrom = new CoinFrom(contractData.getSender(), chainId, assetsId, totalValue, RPCUtil.decode((String)nonce), 0);
        coinData.addFrom(coinFrom);
        if (value.compareTo(BigInteger.ZERO) > 0) {
            CoinTo coinTo = new CoinTo(contractData.getContractAddress(), chainId, assetsId, value);
            coinData.addTo(coinTo);
        }
        if (senderBalance.compareTo(totalValue = totalValue.add(fee = TransactionFeeCalculator.getNormalUnsignedTxFee((int)(txSize + txDataSize + ContractUtil.calcSize((NulsData)coinData))))) < 0) {
            throw new RuntimeException("Insufficient balance");
        }
        coinFrom.setAmount(totalValue);
        return coinData;
    }

    private static int calcSize(NulsData nulsData) {
        if (nulsData == null) {
            return 0;
        }
        int size = nulsData.size();
        return VarInt.sizeOf((long)size) + size - 1;
    }
}

