/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.mykernel;

import io.nuls.core.basic.ModuleConfig;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.core.annotation.Configuration;
import io.nuls.core.core.annotation.Value;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.log.Log;
import io.nuls.core.log.logback.LoggerBuilder;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.config.IniEntity;
import io.nuls.core.rpc.info.NoUse;
import io.nuls.core.rpc.modulebootstrap.NulsRpcModuleBootstrap;
import io.nuls.core.rpc.netty.channel.manager.ConnectManager;
import io.nuls.core.thread.ThreadUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.ini4j.Config;
import org.ini4j.Ini;

@Component
@Configuration(domain="kernel")
public class MyKernelBootstrap
implements ModuleConfig {
    @Value(value="logLevel")
    private String logLevel = "INFO";
    @Value(value="logPath")
    private String logPath;
    @Value(value="dataPath")
    private String dataPath;
    @Value(value="debug")
    private int debug;
    @Value(value="active.config")
    private String config;
    private static List<String> MODULE_STOP_LIST_SCRIPT = new ArrayList<String>();
    static String[] args;
    static NulsLogger log;

    public static void main(String[] args) throws Exception {
        NulsRpcModuleBootstrap.printLogo((String)"/logo");
        System.setProperty("io.netty.tryReflectionSetAccessible", "true");
        MyKernelBootstrap.args = args;
        SpringLiteContext.init((String[])new String[]{"io.nuls.mykernel", "io.nuls.core.rpc.cmd.kernel"});
        MyKernelBootstrap bootstrap = (MyKernelBootstrap)SpringLiteContext.getBean(MyKernelBootstrap.class);
        bootstrap.doStart();
    }

    private void startOtherModule(String[] args) {
        if (args.length > 0 && "startModule".equals(args[0])) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                log.info("jvm shutdown");
                log.info("Stop submodule");
                log.info("Stop Script List");
                MODULE_STOP_LIST_SCRIPT.stream().forEach(arg_0 -> ((NulsLogger)log).info(arg_0));
                MODULE_STOP_LIST_SCRIPT.stream().forEach(stop -> {
                    try {
                        this.printRuntimeConsole(Runtime.getRuntime().exec((String)stop));
                        log.info("Stop submodule:{}", new Object[]{stop});
                    }
                    catch (IOException e) {
                        log.error("An exception occurred when calling the script to stop the module\uff1a{}", new Object[]{stop});
                    }
                });
            }));
            ThreadUtils.createAndRunThread((String)"startModule", () -> {
                try {
                    while (!ConnectManager.isReady()) {
                        TimeUnit.SECONDS.sleep(5L);
                    }
                    File modules = new File(args[1]);
                    try {
                        this.findModule(modules);
                    }
                    catch (Exception e1) {
                        log.error("Error in launching module:{}", new Object[]{modules.getName()});
                    }
                }
                catch (Exception e) {
                    log.error("Error in launching module");
                }
            });
        }
    }

    private void findModule(File modules) throws Exception {
        if (modules.isFile()) {
            return;
        }
        if (Arrays.stream(modules.listFiles()).anyMatch(f -> "Module.ncf".equals(f.getName())) && Arrays.stream(modules.listFiles()).anyMatch(f -> f.getName().endsWith("jar"))) {
            this.startModule(modules);
            return;
        }
        Arrays.stream(modules.listFiles()).forEach(f -> {
            try {
                this.findModule((File)f);
            }
            catch (Exception e) {
                log.error("Error in launching module:{}", new Object[]{f.getName(), e});
            }
        });
    }

    private void startModule(File modules) throws Exception {
        Config cfg = new Config();
        cfg.setMultiSection(true);
        Ini ini = new Ini();
        ini.setConfig(cfg);
        ini.load(new File(modules.getAbsolutePath() + File.separator + "Module.ncf"));
        IniEntity ie = new IniEntity(ini);
        String managed = ie.getCfgValue("Core", "Managed");
        if ("1".equals(managed)) {
            ThreadUtils.createAndRunThread((String)"module-start", () -> {
                Process process = null;
                try {
                    String cmd = modules.getAbsolutePath() + File.separator + "start.sh  --jre " + System.getProperty("java.home") + " --managerurl ws://127.0.0.1:7771/ " + (String)(StringUtils.isNotBlank((String)this.logPath) ? " --logpath " + this.logPath : "") + (String)(StringUtils.isNotBlank((String)this.dataPath) ? " --datapath " + this.dataPath : "") + (String)(StringUtils.isNotBlank((String)this.logLevel) ? " --loglevel " + this.logLevel : "") + " --debug " + this.debug + (String)(StringUtils.isNotBlank((String)this.config) ? " --config " + this.config : "") + " -r ";
                    Log.info((String)"run script:{}", (Object[])new Object[]{cmd});
                    process = Runtime.getRuntime().exec(cmd);
                    List<String> list = MODULE_STOP_LIST_SCRIPT;
                    synchronized (list) {
                        MODULE_STOP_LIST_SCRIPT.add(modules.getAbsolutePath() + File.separator + "stop.sh ");
                    }
                    this.printRuntimeConsole(process);
                }
                catch (IOException e) {
                    log.error("Abnormal startup module", (Exception)e);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printRuntimeConsole(Process process) throws IOException {
        BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            String line;
            while ((line = input.readLine()) != null) {
                log.info(line);
            }
        }
        finally {
            if (Collections.singletonList(input).get(0) != null) {
                input.close();
            }
        }
    }

    public boolean doStart() {
        this.startOtherModule(args);
        int port = 7771;
        String host = "0.0.0.0";
        String path = "/";
        try {
            NoUse.startKernel((String)host, (int)port, (String)path);
        }
        catch (Exception e) {
            log.error("mykernel start fail", e);
        }
        log.info("MYKERNEL STARTED. URL: ws://{}{}", new Object[]{host + ":" + port, path});
        return false;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    static {
        log = LoggerBuilder.getLogger((String)"kernel");
    }
}

