/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.data;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.core.basic.NulsData;
import io.nuls.core.constant.ToolsConstant;
import io.nuls.core.crypto.UnsafeByteArrayOutputStream;
import io.nuls.core.exception.NulsException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;

public abstract class BaseNulsData
implements NulsData,
Serializable,
Cloneable {
    public final byte[] serialize() throws IOException {
        int size = this.size();
        try (UnsafeByteArrayOutputStream bos = new UnsafeByteArrayOutputStream(size);){
            NulsOutputStreamBuffer buffer = new NulsOutputStreamBuffer((OutputStream)bos);
            if (size == 0) {
                bos.write(ToolsConstant.PLACE_HOLDER);
            } else {
                this.serializeToStream(buffer);
            }
            byte[] bytes = bos.toByteArray();
            if (bytes.length != size) {
                throw new RuntimeException();
            }
            byte[] byArray = bytes;
            return byArray;
        }
    }

    protected abstract void serializeToStream(NulsOutputStreamBuffer var1) throws IOException;

    public final void parse(byte[] bytes, int cursor) throws NulsException {
        if (bytes == null || bytes.length == 0 || bytes.length == 4 && Arrays.equals(ToolsConstant.PLACE_HOLDER, bytes)) {
            return;
        }
        NulsByteBuffer byteBuffer = new NulsByteBuffer(bytes);
        byteBuffer.setCursor(cursor);
        this.parse(byteBuffer);
    }

    public abstract void parse(NulsByteBuffer var1) throws NulsException;
}

