/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.data;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.basic.TransactionManager;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Block
extends BaseNulsData
implements Cloneable {
    private BlockHeader header;
    private List<Transaction> txs;
    private transient List<NulsHash> txHashList;
    private transient String nodeId;

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public int size() {
        int size = this.header.size();
        for (Transaction tx : this.txs) {
            size += tx.size();
        }
        return size;
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        this.header.serializeToStream(stream);
        for (Transaction tx : this.txs) {
            stream.write(tx.serialize());
        }
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.header = new BlockHeader();
        this.header.parse(byteBuffer);
        try {
            this.txs = TransactionManager.getInstances(byteBuffer, this.header.getTxCount());
        }
        catch (Exception e) {
            throw new NulsRuntimeException((Throwable)e);
        }
        for (Transaction tx : this.txs) {
            tx.setBlockHeight(this.header.getHeight());
        }
    }

    public List<Transaction> getTxs() {
        return this.txs;
    }

    public void setTxs(List<Transaction> txs) {
        this.txs = txs;
    }

    public BlockHeader getHeader() {
        return this.header;
    }

    public void setHeader(BlockHeader header) {
        this.header = header;
    }

    public List<NulsHash> getTxHashList() {
        if (this.txHashList == null) {
            this.txHashList = new ArrayList<NulsHash>();
            for (Transaction tx : this.txs) {
                if (null == tx) continue;
                this.txHashList.add(tx.getHash());
            }
        }
        return this.txHashList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Block block = (Block)o;
        if (!this.header.equals(block.header)) {
            return false;
        }
        return this.txs.equals(block.txs);
    }

    public int hashCode() {
        int result = this.header.hashCode();
        result = 31 * result + this.txs.hashCode();
        return result;
    }
}

