/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.data;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.core.basic.NulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SmallBlock
extends BaseNulsData {
    private BlockHeader header;
    private ArrayList<NulsHash> txHashList;
    private List<Transaction> systemTxList = new ArrayList<Transaction>();

    public int size() {
        int size = this.header.size();
        size += SerializeUtils.sizeOfVarInt((Integer)this.txHashList.size());
        size += this.txHashList.size() * 32;
        size += SerializeUtils.sizeOfVarInt((Integer)this.systemTxList.size());
        for (Transaction tx : this.systemTxList) {
            size += SerializeUtils.sizeOfNulsData((NulsData)tx);
        }
        return size;
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeNulsData(this.header);
        stream.writeVarInt(this.txHashList.size());
        for (NulsHash hash : this.txHashList) {
            stream.write(hash.getBytes());
        }
        stream.writeVarInt(this.systemTxList.size());
        for (Transaction tx : this.systemTxList) {
            stream.writeNulsData(tx);
        }
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.header = byteBuffer.readNulsData(new BlockHeader());
        this.txHashList = new ArrayList();
        long hashListSize = byteBuffer.readVarInt();
        int i = 0;
        while ((long)i < hashListSize) {
            this.txHashList.add(byteBuffer.readHash());
            ++i;
        }
        this.systemTxList = new ArrayList<Transaction>();
        long subTxListSize = byteBuffer.readVarInt();
        int i2 = 0;
        while ((long)i2 < subTxListSize) {
            Transaction tx = byteBuffer.readTransaction();
            tx.setBlockHeight(this.header.getHeight());
            this.systemTxList.add(tx);
            ++i2;
        }
    }

    public BlockHeader getHeader() {
        return this.header;
    }

    public void setHeader(BlockHeader header) {
        this.header = header;
    }

    public ArrayList<NulsHash> getTxHashList() {
        return this.txHashList;
    }

    public void setTxHashList(ArrayList<NulsHash> txHashList) {
        this.txHashList = txHashList;
    }

    public List<Transaction> getSystemTxList() {
        return this.systemTxList;
    }

    public void addSystemTx(Transaction tx) {
        this.systemTxList.add(tx);
    }
}

