/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.data;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.core.constant.ToolsConstant;
import io.nuls.core.constant.TxStatusEnum;
import io.nuls.core.crypto.UnsafeByteArrayOutputStream;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class Transaction
extends BaseNulsData
implements Cloneable {
    private int type;
    private byte[] coinData;
    private byte[] txData;
    private long time;
    private byte[] transactionSignature;
    private byte[] remark;
    private transient NulsHash hash;
    private transient long blockHeight = -1L;
    private transient TxStatusEnum status = TxStatusEnum.UNCONFIRM;
    private transient int size;
    private transient CoinData coinDataInstance;
    private int inBlockIndex;

    public Transaction() {
    }

    public Transaction(int type) {
        this.type = type;
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfBytes((byte[])this.remark);
        size += SerializeUtils.sizeOfBytes((byte[])this.txData);
        size += SerializeUtils.sizeOfBytes((byte[])this.coinData);
        return size += SerializeUtils.sizeOfBytes((byte[])this.transactionSignature);
    }

    @Override
    public void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.type);
        stream.writeUint32(this.time);
        stream.writeBytesWithLength(this.remark);
        stream.writeBytesWithLength(this.txData);
        stream.writeBytesWithLength(this.coinData);
        stream.writeBytesWithLength(this.transactionSignature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serializeForHash() throws IOException {
        try (ByteArrayOutputStream bos = null;){
            int size = this.size() - SerializeUtils.sizeOfBytes((byte[])this.transactionSignature);
            bos = new UnsafeByteArrayOutputStream(size);
            NulsOutputStreamBuffer buffer = new NulsOutputStreamBuffer(bos);
            if (size == 0) {
                bos.write(ToolsConstant.PLACE_HOLDER);
            } else {
                buffer.writeUint16(this.type);
                buffer.writeUint32(this.time);
                buffer.writeBytesWithLength(this.remark);
                buffer.writeBytesWithLength(this.txData);
                buffer.writeBytesWithLength(this.coinData);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.type = byteBuffer.readUint16();
        this.time = byteBuffer.readUint32();
        this.remark = byteBuffer.readByLengthByte();
        this.txData = byteBuffer.readByLengthByte();
        this.coinData = byteBuffer.readByLengthByte();
        this.transactionSignature = byteBuffer.readByLengthByte();
    }

    public byte[] getTxData() {
        return this.txData;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public byte[] getRemark() {
        return this.remark;
    }

    public void setRemark(byte[] remark) {
        this.remark = remark;
    }

    public NulsHash getHash() {
        if (this.hash == null) {
            try {
                this.hash = NulsHash.calcHash(this.serializeForHash());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.hash;
    }

    public void setHash(NulsHash hash) {
        this.hash = hash;
    }

    public byte[] getTransactionSignature() {
        return this.transactionSignature;
    }

    public void setTransactionSignature(byte[] transactionSignature) {
        this.transactionSignature = transactionSignature;
    }

    public void setTxData(byte[] txData) {
        this.txData = txData;
    }

    public long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public TxStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(TxStatusEnum status) {
        this.status = status;
    }

    public byte[] getCoinData() {
        return this.coinData;
    }

    public int getInBlockIndex() {
        return this.inBlockIndex;
    }

    public void setInBlockIndex(int inBlockIndex) {
        this.inBlockIndex = inBlockIndex;
    }

    public CoinData getCoinDataInstance() throws NulsException {
        if (this.coinDataInstance == null) {
            this.coinDataInstance = new CoinData();
            this.coinDataInstance.parse(new NulsByteBuffer(this.coinData));
        }
        return this.coinDataInstance;
    }

    public void setCoinData(byte[] coinData) {
        this.coinData = coinData;
    }

    public int getSize() {
        if (this.size == 0) {
            this.size = this.size();
        }
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public static Transaction getInstance(byte[] txBytes) throws NulsException {
        NulsByteBuffer nulsByteBuffer = new NulsByteBuffer(txBytes);
        Transaction transaction = new Transaction();
        transaction.parse(nulsByteBuffer);
        return transaction;
    }

    public BigInteger getFee() throws NulsException {
        CoinData cData;
        BigInteger fee = BigInteger.ZERO;
        if (null != this.coinData && this.type > 1 && (cData = this.getCoinDataInstance()).getFrom().size() > 0) {
            BigInteger toAmount = BigInteger.ZERO;
            for (CoinTo coinTo : cData.getTo()) {
                toAmount = toAmount.add(coinTo.getAmount());
            }
            BigInteger fromAmount = BigInteger.ZERO;
            for (CoinFrom coinFrom : cData.getFrom()) {
                fromAmount = fromAmount.add(coinFrom.getAmount());
            }
            fee = fromAmount.subtract(toAmount);
        }
        return fee;
    }

    public boolean isMultiSignTx() throws NulsException {
        if (null == this.coinData) {
            return false;
        }
        CoinData cData = this.getCoinDataInstance();
        List<CoinFrom> from = cData.getFrom();
        if (from == null || from.size() == 0) {
            return false;
        }
        CoinFrom coinFrom = from.get(0);
        return AddressTool.isMultiSignAddress(coinFrom.getAddress());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transaction)) {
            return false;
        }
        return this.getHash().equals(((Transaction)obj).getHash());
    }

    public int hashCode() {
        int result = this.type;
        result = 31 * result + Arrays.hashCode(this.coinData);
        result = 31 * result + Arrays.hashCode(this.txData);
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        result = 31 * result + Arrays.hashCode(this.transactionSignature);
        result = 31 * result + Arrays.hashCode(this.remark);
        return result;
    }
}

