/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.data.po;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.NulsHash;
import io.nuls.base.signture.BlockSignature;
import io.nuls.core.basic.NulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BlockHeaderPo
extends BaseNulsData {
    private NulsHash hash;
    private boolean complete;
    private NulsHash preHash;
    private NulsHash merkleHash;
    private long time;
    private long height;
    private int txCount;
    private BlockSignature blockSignature;
    private byte[] extend;
    private int blockSize;
    private List<NulsHash> txHashList;
    private transient byte[] packingAddress;

    public NulsHash getHash() {
        return this.hash;
    }

    public void setHash(NulsHash hash) {
        this.hash = hash;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public NulsHash getPreHash() {
        return this.preHash;
    }

    public void setPreHash(NulsHash preHash) {
        this.preHash = preHash;
    }

    public NulsHash getMerkleHash() {
        return this.merkleHash;
    }

    public void setMerkleHash(NulsHash merkleHash) {
        this.merkleHash = merkleHash;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    public int getTxCount() {
        return this.txCount;
    }

    public void setTxCount(int txCount) {
        this.txCount = txCount;
    }

    public BlockSignature getBlockSignature() {
        return this.blockSignature;
    }

    public void setBlockSignature(BlockSignature blockSignature) {
        this.blockSignature = blockSignature;
    }

    public byte[] getExtend() {
        return this.extend;
    }

    public void setExtend(byte[] extend) {
        this.extend = extend;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public List<NulsHash> getTxHashList() {
        return this.txHashList;
    }

    public void setTxHashList(List<NulsHash> txHashList) {
        this.txHashList = txHashList;
    }

    public byte[] getPackingAddress(int chainID) {
        if (this.blockSignature != null && this.packingAddress == null) {
            this.packingAddress = AddressTool.getAddress(this.blockSignature.getPublicKey(), chainID);
        }
        return this.packingAddress;
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfBoolean();
        size += 32;
        size += 32;
        size += 32;
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfBytes((byte[])this.extend);
        size += 32 * this.txHashList.size();
        return size += SerializeUtils.sizeOfNulsData((NulsData)this.blockSignature);
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeBoolean(this.complete);
        stream.write(this.hash.getBytes());
        stream.write(this.preHash.getBytes());
        stream.write(this.merkleHash.getBytes());
        stream.writeUint32(this.time);
        stream.writeUint32(this.height);
        stream.writeUint32(this.txCount);
        stream.writeUint32(this.blockSize);
        stream.writeBytesWithLength(this.extend);
        stream.writeNulsData(this.blockSignature);
        for (NulsHash hash : this.txHashList) {
            stream.write(hash.getBytes());
        }
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.complete = byteBuffer.readBoolean();
        this.hash = byteBuffer.readHash();
        this.preHash = byteBuffer.readHash();
        this.merkleHash = byteBuffer.readHash();
        this.time = byteBuffer.readUint32();
        this.height = byteBuffer.readUint32();
        this.txCount = byteBuffer.readInt32();
        this.blockSize = byteBuffer.readInt32();
        this.extend = byteBuffer.readByLengthByte();
        this.txHashList = new ArrayList<NulsHash>();
        this.blockSignature = byteBuffer.readNulsData(new BlockSignature());
        for (int i = 0; i < this.txCount; ++i) {
            this.txHashList.add(byteBuffer.readHash());
        }
    }
}

